/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin.rules;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.css.plugin.rules.CssRule;
import org.sonar.css.plugin.rules.RuleUtils;

@Rule(key="S4659")
public class SelectorPseudoClassNoUnknown
implements CssRule {
    private static final String DEFAULT_IGNORED_PSEUDO_CLASSES = "local,global,export,import";
    @RuleProperty(key="ignorePseudoClasses", description="Comma-separated list of strings and/or regular expressions for pseudo classes to consider as valid.", defaultValue="local,global,export,import")
    String ignoredPseudoClasses = "local,global,export,import";

    @Override
    public String stylelintKey() {
        return "selector-pseudo-class-no-unknown";
    }

    @Override
    public List<Object> stylelintOptions() {
        return Arrays.asList(true, new StylelintIgnoreOption(RuleUtils.splitAndTrim(this.ignoredPseudoClasses)));
    }

    private static class StylelintIgnoreOption {
        private final List<String> ignorePseudoClasses;

        StylelintIgnoreOption(List<String> ignorePseudoClasses) {
            this.ignorePseudoClasses = ignorePseudoClasses;
        }
    }
}

