/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.css.plugin.server.bundle;

import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.sonar.api.internal.google.common.annotations.VisibleForTesting;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.css.plugin.server.bundle.Bundle;
import org.sonar.css.plugin.server.bundle.Zip;
import org.sonarsource.api.sonarlint.SonarLintSide;

@ScannerSide
@SonarLintSide(lifespan="MULTIPLE_ANALYSES")
public class CssAnalyzerBundle
implements Bundle {
    private static final Logger LOG = Loggers.get(CssAnalyzerBundle.class);
    private static final Profiler PROFILER = Profiler.createIfDebug((Logger)LOG);
    private static final String DEFAULT_BUNDLE_LOCATION = "/css-bundle.zip";
    private static final Path DEFAULT_STARTUP_SCRIPT = Paths.get("css-bundle", "bin", "server");
    final String bundleLocation;
    private String startServerScript = DEFAULT_STARTUP_SCRIPT.toString();
    private Path deployLocation;

    public CssAnalyzerBundle() {
        this(DEFAULT_BUNDLE_LOCATION);
    }

    @VisibleForTesting
    CssAnalyzerBundle(String bundleLocation) {
        this.bundleLocation = bundleLocation;
    }

    @Override
    public void deploy(Path deployLocation) {
        this.deployLocation = deployLocation;
        PROFILER.startDebug("Deploying bundle");
        LOG.debug("Deploying css-bundle into {}", (Object)deployLocation);
        InputStream bundle = this.getClass().getResourceAsStream(this.bundleLocation);
        if (bundle == null) {
            throw new IllegalStateException("css-bundle not found in " + this.bundleLocation);
        }
        try {
            LOG.debug("Deploying css-bundle to {}", (Object)deployLocation.toAbsolutePath());
            Zip.extract(bundle, deployLocation);
            this.startServerScript = deployLocation.resolve(DEFAULT_STARTUP_SCRIPT).toAbsolutePath().toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to deploy css-bundle (with classpath '" + this.bundleLocation + "')", e);
        }
        PROFILER.stopDebug();
    }

    @Override
    public String startServerScript() {
        return this.startServerScript;
    }

    @Override
    public String resolve(String relativePath) {
        return this.deployLocation.resolve("css-bundle").resolve(relativePath).toString();
    }
}

