/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.dotnet.tests.NUnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultParser;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;
import org.sonar.plugins.dotnet.tests.XmlTestReportParser;

@ScannerSide
public class NUnitTestResultsParser
implements UnitTestResultParser {
    private static final Logger LOG = LoggerFactory.getLogger(NUnitTestResultsParser.class);

    @Override
    public void parse(File file, Map<String, UnitTestResults> unitTestResults, Map<String, String> methodFileMap) {
        LOG.info("Parsing the NUnit Test Results file '{}'.", (Object)file.getAbsolutePath());
        Parser parser = new Parser(file, unitTestResults, methodFileMap, List.of("test-run", "test-results"));
        Map<String, Consumer<XmlParserHelper>> tagHandlers = Map.of("test-suite", parser::handleTestSuiteTag, "test-case", parser::handleTestCaseTag);
        parser.parse(tagHandlers);
    }

    private static class Parser
    extends XmlTestReportParser {
        private String dllName;

        Parser(File file, Map<String, UnitTestResults> unitTestResults, Map<String, String> methodFileMap, List<String> rootTags) {
            super(file, unitTestResults, methodFileMap, rootTags);
        }

        private void handleTestSuiteTag(XmlParserHelper xmlParserHelper) {
            String type = xmlParserHelper.getRequiredAttribute("type");
            if (type.equals("Assembly")) {
                String assemblyName = Parser.extractName(xmlParserHelper);
                this.dllName = this.extractDllNameFromFilePath(assemblyName);
                LOG.debug("NUnit Assembly found, assembly: {}, Extracted dllName: {}", (Object)assemblyName, (Object)this.dllName);
            }
        }

        private void handleTestCaseTag(XmlParserHelper xmlParserHelper) {
            String result = xmlParserHelper.getRequiredAttribute("result");
            String label = xmlParserHelper.getAttribute("label");
            Long executionTime = Parser.extractExecutionTime(xmlParserHelper);
            NUnitTestResults testResults = new NUnitTestResults(result, label, executionTime);
            String name = Parser.extractName(xmlParserHelper);
            String fullName = this.getFullName(name, this.dllName);
            this.addTestResultToFile(fullName, testResults);
        }

        private static Long extractExecutionTime(XmlParserHelper xmlParserHelper) {
            Double time = xmlParserHelper.getDoubleAttribute("duration");
            if (time == null) {
                time = xmlParserHelper.getDoubleAttribute("time");
            }
            return time == null ? null : Long.valueOf((long)(time * 1000.0));
        }

        private static String extractName(XmlParserHelper xmlParserHelper) {
            String name = xmlParserHelper.getAttribute("fullname");
            if (name == null) {
                name = xmlParserHelper.getRequiredAttribute("name");
            }
            return name;
        }
    }
}

