/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.dotnet.tests.ParseErrorException;
import org.sonar.plugins.dotnet.tests.UnitTestResultParser;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.VisualStudioTestResults;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;
import org.sonar.plugins.dotnet.tests.XmlTestReportParser;

@ScannerSide
public class VisualStudioTestResultParser
implements UnitTestResultParser {
    private static final Logger LOG = LoggerFactory.getLogger(VisualStudioTestResultParser.class);

    @Override
    public void parse(File file, Map<String, UnitTestResults> unitTestResults, Map<String, String> methodFileMap) {
        LOG.info("Parsing the Visual Studio Test Results file '{}'.", (Object)file.getAbsolutePath());
        Parser parser = new Parser(file, unitTestResults, methodFileMap, List.of("TestRun"));
        Map<String, Consumer<XmlParserHelper>> tagHandlers = Map.of("UnitTestResult", parser::handleUnitTestResultTag, "UnitTest", parser::handleUnitTestTag);
        parser.parse(tagHandlers);
    }

    private static class Parser
    extends XmlTestReportParser {
        private final Map<String, UnitTestResults> testIdTestResultMap;
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        private final Pattern millisecondsPattern = Pattern.compile("(\\.(\\d{0,3}))\\d*+");

        Parser(File file, Map<String, UnitTestResults> unitTestResults, Map<String, String> methodFileMap, List<String> rootTags) {
            super(file, unitTestResults, methodFileMap, rootTags);
            this.testIdTestResultMap = new HashMap<String, UnitTestResults>();
        }

        private void handleUnitTestResultTag(XmlParserHelper xmlParserHelper) {
            String testId = xmlParserHelper.getRequiredAttribute("testId");
            String outcome = xmlParserHelper.getRequiredAttribute("outcome");
            Date start = this.getRequiredDateAttribute(xmlParserHelper, "startTime");
            Date finish = this.getRequiredDateAttribute(xmlParserHelper, "endTime");
            long duration = finish.getTime() - start.getTime();
            VisualStudioTestResults testResult = new VisualStudioTestResults(outcome, duration);
            if (this.testIdTestResultMap.containsKey(testId)) {
                this.testIdTestResultMap.get(testId).add(testResult);
            } else {
                this.testIdTestResultMap.put(testId, testResult);
            }
            LOG.debug("Parsed Visual Studio Unit Test - testId: {} outcome: {}, duration: {}", new Object[]{testId, outcome, duration});
        }

        private void handleUnitTestTag(XmlParserHelper xmlParserHelper) {
            String tagName;
            String testId = xmlParserHelper.getRequiredAttribute("id");
            while ((tagName = xmlParserHelper.nextStartTag()) != null && !"TestMethod".equals(tagName)) {
            }
            if (tagName == null) {
                throw new ParseErrorException("No TestMethod attribute found on UnitTest tag");
            }
            String methodName = xmlParserHelper.getRequiredAttribute("name");
            String className = xmlParserHelper.getRequiredAttribute("className");
            String codeBase = xmlParserHelper.getRequiredAttribute("codeBase");
            String dllName = this.extractDllNameFromFilePath(codeBase);
            String fullyQualifiedName = this.getFullName(className + "." + methodName, dllName);
            UnitTestResults testIdTestResult = this.testIdTestResultMap.get(testId);
            this.addTestResultToFile(fullyQualifiedName, testIdTestResult);
        }

        private Date getRequiredDateAttribute(XmlParserHelper xmlParserHelper, String name) {
            String value = xmlParserHelper.getRequiredAttribute(name);
            try {
                value = this.keepOnlyMilliseconds(value);
                return this.dateFormat.parse(value);
            }
            catch (ParseException e) {
                throw xmlParserHelper.parseError("Expected a valid date and time instead of \"" + value + "\" for the attribute \"" + name + "\". " + e.getMessage());
            }
        }

        private String keepOnlyMilliseconds(String value) {
            StringBuilder sb = new StringBuilder();
            Matcher matcher = this.millisecondsPattern.matcher(value);
            StringBuilder trailingZeros = new StringBuilder();
            while (matcher.find()) {
                String milliseconds = matcher.group(2);
                trailingZeros.setLength(0);
                trailingZeros.append("0".repeat(Math.max(0, 3 - milliseconds.length())));
                matcher.appendReplacement(sb, "$1" + trailingZeros);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }
}

