/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.Serializable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsAggregator;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;
import org.sonarsource.dotnet.shared.plugins.DotNetPluginMetadata;

public class UnitTestResultsImportSensor
implements ProjectSensor {
    private static final Logger LOG = Loggers.get(UnitTestResultsImportSensor.class);
    private final WildcardPatternFileProvider wildcardPatternFileProvider = new WildcardPatternFileProvider(new File("."));
    private final UnitTestResultsAggregator unitTestResultsAggregator;
    private final String languageKey;
    private final String languageName;
    private final AnalysisWarnings analysisWarnings;

    public UnitTestResultsImportSensor(UnitTestResultsAggregator unitTestResultsAggregator, DotNetPluginMetadata pluginMetadata, AnalysisWarnings analysisWarnings) {
        this.unitTestResultsAggregator = unitTestResultsAggregator;
        this.languageKey = pluginMetadata.languageKey();
        this.languageName = pluginMetadata.languageName();
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        String name = String.format("%s Unit Test Results Import", this.languageName);
        descriptor.name(name);
        descriptor.onlyOnLanguage(this.languageKey);
        descriptor.onlyWhenConfiguration(c -> this.unitTestResultsAggregator.hasUnitTestResultsProperty(arg_0 -> ((Configuration)c).hasKey(arg_0)));
    }

    public void execute(SensorContext context) {
        if (this.unitTestResultsAggregator.hasUnitTestResultsProperty()) {
            try {
                this.saveTestMetrics(context);
            }
            catch (Exception e) {
                LOG.warn("Could not import unit test report: '{}'", (Object)e.getMessage());
                this.analysisWarnings.addUnique(String.format("Could not import unit test report for '%s'. Please check the logs for more details.", this.languageName));
            }
        } else {
            LOG.debug("No unit test results property. Skip Sensor");
        }
    }

    private void saveTestMetrics(SensorContext context) {
        UnitTestResults aggregatedResults = this.unitTestResultsAggregator.aggregate(this.wildcardPatternFileProvider);
        context.newMeasure().forMetric((Metric)CoreMetrics.TESTS).on((InputComponent)context.project()).withValue((Serializable)Integer.valueOf(aggregatedResults.tests())).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.TEST_ERRORS).on((InputComponent)context.project()).withValue((Serializable)Integer.valueOf(aggregatedResults.errors())).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.TEST_FAILURES).on((InputComponent)context.project()).withValue((Serializable)Integer.valueOf(aggregatedResults.failures())).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.SKIPPED_TESTS).on((InputComponent)context.project()).withValue((Serializable)Integer.valueOf(aggregatedResults.skipped())).save();
        Long executionTime = aggregatedResults.executionTime();
        if (executionTime != null) {
            context.newMeasure().forMetric((Metric)CoreMetrics.TEST_EXECUTION_TIME).on((InputComponent)context.project()).withValue((Serializable)executionTime).save();
        }
    }
}

