/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;
import org.sonar.plugins.dotnet.tests.DotCoverReportParser;
import org.sonarsource.dotnet.shared.CallableUtils;

public class DotCoverReportsAggregator
implements CoverageParser {
    private static final Logger LOG = LoggerFactory.getLogger(DotCoverReportsAggregator.class);
    private final DotCoverReportParser parser;

    DotCoverReportsAggregator(DotCoverReportParser parser) {
        this.parser = parser;
    }

    @Override
    public void accept(File file, Coverage coverage) {
        LOG.debug("The current user dir is '{}'.", CallableUtils.lazy(() -> System.getProperty("user.dir")));
        LOG.info("Aggregating the HTML reports from '{}'.", (Object)file.getAbsolutePath());
        DotCoverReportsAggregator.checkIsHtml(file);
        String folderName = DotCoverReportsAggregator.extractFolderName(file);
        File folder = new File(file.getParentFile(), folderName + "/src");
        if (!folder.exists()) {
            throw new IllegalArgumentException("The following report dotCover report HTML sources folder cannot be found: " + folder.getAbsolutePath());
        }
        List<File> reportFiles = DotCoverReportsAggregator.listReportFiles(folder);
        LOG.debug("dotCover aggregator: collected {} report files to parse.", (Object)reportFiles.size());
        for (File reportFile : reportFiles) {
            if (DotCoverReportsAggregator.isExcluded(reportFile)) continue;
            this.parser.accept(reportFile, coverage);
        }
        if (reportFiles.isEmpty()) {
            throw new IllegalArgumentException("No dotCover report HTML source file found under: " + folder.getAbsolutePath());
        }
    }

    private static List<File> listReportFiles(File folder) {
        List<File> list;
        block8: {
            Stream<Path> pathStream = Files.list(folder.toPath());
            try {
                list = pathStream.map(Path::toFile).filter(f -> f.isFile() && f.getName().endsWith(".html")).collect(Collectors.toList());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            pathStream.close();
        }
        return list;
    }

    private static void checkIsHtml(File file) {
        String contents;
        try {
            contents = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (!contents.startsWith("<!DOCTYPE html>")) {
            throw new IllegalArgumentException("Only dotCover HTML reports which start with \"<!DOCTYPE html>\" are supported.");
        }
    }

    private static String extractFolderName(File file) {
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            throw new IllegalArgumentException("The following dotCover report name should have an extension: " + name);
        }
        return name.substring(0, lastDot);
    }

    private static boolean isExcluded(File file) {
        return "nosource.html".equals(file.getName());
    }
}

