/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.dotnet.tests.BranchPoint;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;
import org.sonar.plugins.dotnet.tests.FileService;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;
import org.sonarsource.dotnet.shared.CallableUtils;

public class OpenCoverReportParser
implements CoverageParser {
    private static final Logger LOG = LoggerFactory.getLogger(OpenCoverReportParser.class);
    private final FileService fileService;

    OpenCoverReportParser(FileService fileService) {
        this.fileService = fileService;
    }

    @Override
    public void accept(File file, Coverage coverage) {
        LOG.debug("The current user dir is '{}'.", CallableUtils.lazy(() -> System.getProperty("user.dir")));
        LOG.info("Parsing the OpenCover report {}", (Object)file.getAbsolutePath());
        new Parser(file, coverage).parse();
    }

    private class Parser {
        private final File file;
        private final Coverage coverage;
        private final Map<String, CoveredFile> files = new HashMap<String, CoveredFile>();
        private String currentFileRefUid;

        Parser(File file, Coverage coverage) {
            this.file = file;
            this.coverage = coverage;
        }

        public void parse() {
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                xmlParserHelper.checkRootTag("CoverageSession");
                this.dispatchTags(xmlParserHelper);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private void dispatchTags(XmlParserHelper xmlParserHelper) {
            String tagName;
            while ((tagName = xmlParserHelper.nextStartTag()) != null) {
                if ("File".equals(tagName)) {
                    this.handleFileTag(xmlParserHelper);
                    continue;
                }
                if ("FileRef".equals(tagName)) {
                    this.handleFileRef(xmlParserHelper);
                    continue;
                }
                if ("SequencePoint".equals(tagName)) {
                    this.handleSequencePointTag(xmlParserHelper);
                    continue;
                }
                if (!"BranchPoint".equals(tagName)) continue;
                this.handleBranchPointTag(xmlParserHelper);
            }
        }

        private void handleFileRef(XmlParserHelper xmlParserHelper) {
            this.currentFileRefUid = xmlParserHelper.getRequiredAttribute("uid");
        }

        private void handleFileTag(XmlParserHelper xmlParserHelper) {
            String canonicalPath;
            String uid = xmlParserHelper.getRequiredAttribute("uid");
            String pathInCoverageFile = xmlParserHelper.getRequiredAttribute("fullPath");
            try {
                canonicalPath = new File(pathInCoverageFile).getCanonicalPath();
            }
            catch (IOException e) {
                LOG.debug("Skipping the import of OpenCover code coverage for the invalid file path: " + pathInCoverageFile + " at line " + xmlParserHelper.stream().getLocation().getLineNumber(), (Throwable)e);
                return;
            }
            CoveredFile coveredFile = this.createCoveredFile(canonicalPath, uid, pathInCoverageFile);
            LOG.debug("CoveredFile created: {}.", (Object)coveredFile);
            this.files.put(uid, coveredFile);
        }

        private void handleSequencePointTag(XmlParserHelper xmlParserHelper) {
            int line = xmlParserHelper.getRequiredIntAttribute("sl");
            int visitCount = xmlParserHelper.getRequiredIntAttribute("vc");
            String fileId = xmlParserHelper.getAttribute("fileid");
            if (fileId == null) {
                fileId = this.currentFileRefUid;
            }
            if (this.files.containsKey(fileId)) {
                CoveredFile coveredFile = this.files.get(fileId);
                if (coveredFile.isIndexed()) {
                    this.coverage.addHits(coveredFile.indexedPath, line, visitCount);
                    LOG.trace("OpenCover parser: add hits for file {}, line '{}', visitCount '{}'.", new Object[]{coveredFile, line, visitCount});
                } else {
                    LOG.debug("Skipping the file {}, line '{}', visitCount '{}' because file is not indexed or does not have the supported language.", new Object[]{coveredFile, line, visitCount});
                }
            } else {
                LOG.debug("OpenCover parser (handleSequencePointTag): the fileId '{}' key is not contained in files (entry for line '{}', visitCount '{}').", new Object[]{fileId, line, visitCount});
            }
        }

        private void handleBranchPointTag(XmlParserHelper xmlParserHelper) {
            String fileId = xmlParserHelper.getAttribute("fileid");
            if (fileId == null) {
                fileId = this.currentFileRefUid;
            }
            if (this.files.containsKey(fileId)) {
                CoveredFile coveredFile = this.files.get(fileId);
                int line = xmlParserHelper.getIntAttributeOrZero("sl");
                if (line == 0) {
                    LOG.warn("OpenCover parser: invalid start line for file {}.", (Object)coveredFile);
                    return;
                }
                int offset = xmlParserHelper.getRequiredIntAttribute("offset");
                int offsetEnd = xmlParserHelper.getRequiredIntAttribute("offsetend");
                int path = xmlParserHelper.getRequiredIntAttribute("path");
                int visitCount = xmlParserHelper.getRequiredIntAttribute("vc");
                if (coveredFile.isIndexed()) {
                    this.coverage.add(new BranchPoint(coveredFile.indexedPath, line, offset, offsetEnd, path, visitCount));
                    LOG.trace("OpenCover parser: add branch hits for file {}, line '{}', offset '{}', visitCount '{}'.", new Object[]{coveredFile, line, offset, visitCount});
                } else {
                    LOG.debug("OpenCover parser: Skipping branch hits for file {}, line '{}', offset '{}', visitCount '{}' because file is not indexed or does not have the supported language.", new Object[]{coveredFile, line, offset, visitCount});
                }
            } else {
                LOG.debug("OpenCover parser (handleBranchPointTag): the fileId '{}' key is not contained in files.", (Object)fileId);
            }
        }

        private CoveredFile createCoveredFile(String canonicalPath, String uid, String pathInCoverageFile) {
            if (OpenCoverReportParser.this.fileService.isSupportedAbsolute(canonicalPath)) {
                return new CoveredFile(uid, pathInCoverageFile, canonicalPath);
            }
            return OpenCoverReportParser.this.fileService.getAbsolutePath(pathInCoverageFile).map(path -> new CoveredFile(uid, pathInCoverageFile, (String)path)).orElseGet(() -> new CoveredFile(uid, pathInCoverageFile, null));
        }
    }

    private static class CoveredFile {
        final String uid;
        final String originalPath;
        final String indexedPath;

        CoveredFile(String uid, String originalPath, @Nullable String indexedPath) {
            this.uid = uid;
            this.originalPath = originalPath;
            this.indexedPath = indexedPath;
        }

        boolean isIndexed() {
            return this.indexedPath != null;
        }

        public String toString() {
            return this.indexedPath == null ? String.format("(ID '%s', path '%s', NO INDEXED PATH)", this.uid, this.originalPath) : String.format("(ID '%s', path '%s', indexed as '%s')", this.uid, this.originalPath, this.indexedPath);
        }
    }
}

