/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.bootstrap.ProjectBuilder;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputFile;
import org.sonarsource.dotnet.shared.plugins.AbstractModuleConfiguration;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;
import org.sonarsource.dotnet.shared.plugins.protobuf.FileMetadataImporter;

@Phase(name=Phase.Name.POST)
public abstract class AbstractGlobalProtobufFileProcessor
extends ProjectBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGlobalProtobufFileProcessor.class);
    private final String languageKey;
    private final Map<String, Charset> roslynEncodingPerUri = new TreeMap<String, Charset>(String.CASE_INSENSITIVE_ORDER);
    private final Set<String> generatedFileUris = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    public AbstractGlobalProtobufFileProcessor(String languageKey) {
        this.languageKey = languageKey;
    }

    public void build(ProjectBuilder.Context context) {
        for (ProjectDefinition p : context.projectReactor().getProjects()) {
            for (Path reportPath : this.protobufReportPaths(p.properties())) {
                this.processMetadataReportIfPresent(reportPath);
            }
        }
    }

    private void processMetadataReportIfPresent(Path reportPath) {
        Path metadataReportProtobuf = reportPath.resolve("file-metadata.pb");
        if (metadataReportProtobuf.toFile().exists()) {
            LOG.debug("Processing {}", (Object)metadataReportProtobuf);
            FileMetadataImporter fileMetadataImporter = new FileMetadataImporter();
            fileMetadataImporter.accept(metadataReportProtobuf);
            this.generatedFileUris.addAll(fileMetadataImporter.getGeneratedFileUris().stream().map(URI::toString).collect(Collectors.toList()));
            for (Map.Entry<URI, Charset> entry : fileMetadataImporter.getEncodingPerUri().entrySet()) {
                String key = entry.getKey().toString();
                if (!this.roslynEncodingPerUri.containsKey(key)) {
                    this.roslynEncodingPerUri.put(key, entry.getValue());
                    continue;
                }
                if (this.roslynEncodingPerUri.get(key) == entry.getValue()) continue;
                LOG.warn("Different encodings {} vs. {} were detected for single file {}. Case-Sensitive paths are not supported.", new Object[]{this.roslynEncodingPerUri.get(key), entry.getValue(), key});
            }
        }
    }

    public Map<String, Charset> getRoslynEncodingPerUri() {
        return Collections.unmodifiableMap(this.roslynEncodingPerUri);
    }

    public boolean isGenerated(InputFile inputFile) {
        return this.generatedFileUris.contains(inputFile.uri().toString());
    }

    private List<Path> protobufReportPaths(Map<String, String> moduleProps) {
        return Arrays.stream(this.parseAsStringArray(moduleProps.get(AbstractPropertyDefinitions.getAnalyzerWorkDirProperty(this.languageKey)))).map(x -> Paths.get(x, new String[0]).resolve(AbstractModuleConfiguration.getAnalyzerReportDir(this.languageKey))).collect(Collectors.toList());
    }

    private String[] parseAsStringArray(@Nullable String value) {
        if (value == null) {
            return new String[0];
        }
        List<String> escapedValues = Arrays.asList(value.split(","));
        return (String[])escapedValues.stream().map(String::trim).map(s -> AbstractGlobalProtobufFileProcessor.removeStart(s, "\"")).map(s -> AbstractGlobalProtobufFileProcessor.removeEnd(s, "\"")).toArray(String[]::new);
    }

    private static String removeStart(String s, String start) {
        return s.startsWith(start) ? s.substring(start.length()) : s;
    }

    private static String removeEnd(String s, String end) {
        return s.endsWith(end) ? s.substring(0, s.length() - end.length()) : s;
    }
}

