/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.Version;

public abstract class AbstractPropertyDefinitions {
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";
    protected static final String PROP_PREFIX = "sonar.";
    public static final String PROJECT_KEY_PROPERTY = "sonar.projectKey";
    public static final String PROJECT_NAME_PROPERTY = "sonar.projectName";
    public static final String PROJECT_BASE_DIR_PROPERTY = "sonar.projectBaseDir";
    private final String languageKey;
    private final String languageName;
    private final String fileSuffixDefaultValue;
    private final SonarRuntime runtime;

    public AbstractPropertyDefinitions(String languageKey, String languageName, String fileSuffixDefaultValue, SonarRuntime runtime) {
        this.languageKey = languageKey;
        this.languageName = languageName;
        this.fileSuffixDefaultValue = fileSuffixDefaultValue;
        this.runtime = runtime;
    }

    public List<PropertyDefinition> create() {
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getRoslynJsonReportPathProperty(this.languageKey)).multiValues(true).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getAnalyzerWorkDirProperty(this.languageKey)).multiValues(true).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getFileSuffixProperty(this.languageKey)).category(this.languageName).defaultValue(this.fileSuffixDefaultValue).name("File suffixes").description("List of suffixes for files to analyze.").multiValues(true).onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getIgnoreHeaderCommentsProperty(this.languageKey)).category(this.languageName).defaultValue("true").name("Ignore header comments").description("If set to \"true\", the file headers (that are usually the same on each file: licensing information for example) are not considered as comments. Thus metrics such as \"Comment lines\" do not get incremented. If set to \"false\", those file headers are considered as comments and metrics such as \"Comment lines\" get incremented.").onQualifiers("TRK", new String[0]).type(PropertyType.BOOLEAN).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getAnalyzeGeneratedCode(this.languageKey)).category(this.languageName).defaultValue("false").name("Analyze generated code").description("If set to \"true\", the files containing generated code are analyzed. If set to \"false\", the files containing generated code are ignored.").onQualifiers("TRK", new String[0]).type(PropertyType.BOOLEAN).build());
        if (this.runtime.getApiVersion().isGreaterThanOrEqual(Version.create((int)7, (int)4))) {
            result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getIgnoreIssuesProperty(this.languageKey)).type(PropertyType.BOOLEAN).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(this.languageName).index(0).defaultValue("false").name("Ignore issues from external Roslyn analyzers").description("If set to 'true', issues reported by external Roslyn analyzers won't be imported.").onQualifiers("TRK", new String[0]).build());
            result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getBugCategoriesProperty(this.languageKey)).type(PropertyType.STRING).multiValues(true).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(this.languageName).index(1).name("Rule categories associated with Bugs").description("External rule categories to be treated as Bugs.").onQualifiers("TRK", new String[0]).build());
            result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getVulnerabilityCategoriesProperty(this.languageKey)).type(PropertyType.STRING).multiValues(true).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(this.languageName).index(2).name("Rule categories associated with Vulnerabilities").description("External rule categories to be treated as Vulnerabilities.").onQualifiers("TRK", new String[0]).build());
            result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.getCodeSmellCategoriesProperty(this.languageKey)).type(PropertyType.STRING).multiValues(true).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(this.languageName).index(3).name("Rule categories associated with Code Smells").description("External rule categories to be treated as Code Smells. By default, external issues are Code Smells, or Bugs when the severity is error.").onQualifiers("TRK", new String[0]).build());
        }
        return result;
    }

    public static String getIgnoreHeaderCommentsProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".ignoreHeaderComments";
    }

    public static String getAnalyzeGeneratedCode(String languageKey) {
        return PROP_PREFIX + languageKey + ".analyzeGeneratedCode";
    }

    public static String getFileSuffixProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".file.suffixes";
    }

    public static String getRoslynJsonReportPathProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.reportFilePaths";
    }

    public static String getAnalyzerWorkDirProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".analyzer.projectOutPaths";
    }

    public static String getIgnoreIssuesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.ignoreIssues";
    }

    public static String getBugCategoriesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.bugCategories";
    }

    public static String getCodeSmellCategoriesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.codeSmellCategories";
    }

    public static String getVulnerabilityCategoriesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.vulnerabilityCategories";
    }

    public static String getPullRequestCacheBasePath() {
        return "sonar.pullrequest.cache.basepath";
    }

    public static String getPullRequestBase() {
        return "sonar.pullrequest.base";
    }
}

