/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import com.google.protobuf.Parser;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;

public class FileMetadataImporter
extends RawProtobufImporter<SonarAnalyzer.FileMetadataInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(FileMetadataImporter.class);
    private final Map<URI, Charset> encodingPerUri = new HashMap<URI, Charset>();
    private final Set<URI> generatedFileUris = new HashSet<URI>();

    FileMetadataImporter(Parser<SonarAnalyzer.FileMetadataInfo> parser) {
        super(parser);
    }

    public FileMetadataImporter() {
        this(SonarAnalyzer.FileMetadataInfo.parser());
    }

    @Override
    void consume(SonarAnalyzer.FileMetadataInfo message) {
        URI fileUri = Paths.get(message.getFilePath(), new String[0]).toUri();
        if (message.getIsGenerated()) {
            this.generatedFileUris.add(fileUri);
        }
        String roslynEncoding = message.getEncoding();
        Charset charset = null;
        if (!roslynEncoding.isEmpty()) {
            try {
                charset = Charset.forName(roslynEncoding);
            }
            catch (Exception e) {
                LOG.warn(String.format("Unrecognized encoding %s for file %s", roslynEncoding, message.getFilePath()), (Throwable)e);
            }
        }
        this.encodingPerUri.put(fileUri, charset);
    }

    public Map<URI, Charset> getEncodingPerUri() {
        return Collections.unmodifiableMap(this.encodingPerUri);
    }

    public Set<URI> getGeneratedFileUris() {
        return this.generatedFileUris;
    }
}

