/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.WeakHashMap;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;

public class CoverageCache {
    private static final Logger LOG = Loggers.get(CoverageCache.class);
    private final WeakHashMap<String, Coverage> cache = new WeakHashMap();

    public Coverage readCoverageFromCacheOrParse(CoverageParser parser, File reportFile) {
        String path = reportFile.getAbsolutePath();
        Coverage coverage = this.cache.get(path);
        if (coverage == null) {
            coverage = new Coverage();
            parser.parse(reportFile, coverage);
            this.cache.put(path, coverage);
            LOG.info("Adding this code coverage report to the cache for later reuse: " + path);
        } else {
            LOG.info("Successfully retrieved this code coverage report results from the cache: " + path);
        }
        return coverage;
    }
}

