/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Map;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageAggregator;
import org.sonar.plugins.dotnet.tests.CoverageConfiguration;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;

public class CoverageReportImportSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(CoverageReportImportSensor.class);
    private final WildcardPatternFileProvider wildcardPatternFileProvider = new WildcardPatternFileProvider(new File("."), File.separator);
    private final CoverageConfiguration coverageConf;
    private final CoverageAggregator coverageAggregator;
    private final boolean isIntegrationTest;

    public CoverageReportImportSensor(CoverageConfiguration coverageConf, CoverageAggregator coverageAggregator, boolean isIntegrationTest) {
        this.coverageConf = coverageConf;
        this.coverageAggregator = coverageAggregator;
        this.isIntegrationTest = isIntegrationTest;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Coverage Report Import");
    }

    public void execute(SensorContext context) {
        if (!this.coverageAggregator.hasCoverageProperty()) {
            LOG.debug("No coverage property. Skip Sensor");
            return;
        }
        this.analyze(context, new Coverage());
    }

    @VisibleForTesting
    void analyze(SensorContext context, Coverage coverage) {
        this.coverageAggregator.aggregate(this.wildcardPatternFileProvider, coverage);
        for (String filePath : coverage.files()) {
            FilePredicates p = context.fileSystem().predicates();
            InputFile inputFile = context.fileSystem().inputFile(p.and(p.hasType(InputFile.Type.MAIN), p.hasAbsolutePath(filePath)));
            if (inputFile == null) {
                LOG.debug("Code coverage will not be imported for the following file outside of SonarQube: " + filePath);
                continue;
            }
            if (!this.coverageConf.languageKey().equals(inputFile.language())) continue;
            NewCoverage newCoverage = context.newCoverage().onFile(inputFile).ofType(this.isIntegrationTest ? CoverageType.IT : CoverageType.UNIT);
            for (Map.Entry<Integer, Integer> entry : coverage.hits(filePath).entrySet()) {
                newCoverage.lineHits(entry.getKey().intValue(), entry.getValue().intValue());
            }
            newCoverage.save();
        }
    }
}

