/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;

public abstract class XmlTestReportParser {
    private static final Logger LOG = LoggerFactory.getLogger(XmlTestReportParser.class);
    protected final File file;
    protected final Map<String, String> methodFileMap;
    protected final Map<String, UnitTestResults> unitTestResults;
    protected final List<String> rootTags;

    XmlTestReportParser(File file, Map<String, UnitTestResults> unitTestResults, Map<String, String> methodFileMap, List<String> rootTags) {
        this.file = file;
        this.unitTestResults = unitTestResults;
        this.methodFileMap = methodFileMap;
        this.rootTags = rootTags;
    }

    public void parse(Map<String, Consumer<XmlParserHelper>> tagHandlers) {
        try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
            String tag = xmlParserHelper.checkRootTags(this.rootTags);
            do {
                if (!tagHandlers.containsKey(tag)) continue;
                tagHandlers.get(tag).accept(xmlParserHelper);
            } while ((tag = xmlParserHelper.nextStartTag()) != null);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to close report", e);
        }
    }

    protected void addTestResultToFile(String methodFullName, UnitTestResults testResults) {
        if (!this.methodFileMap.containsKey(methodFullName)) {
            LOG.debug("Test method {} cannot be mapped to the test source file. The test will not be included.", (Object)methodFullName);
            return;
        }
        String fileName = this.methodFileMap.get(methodFullName);
        if (this.unitTestResults.containsKey(fileName)) {
            UnitTestResults fileTestResult = this.unitTestResults.get(fileName);
            fileTestResult.add(testResults);
        } else {
            this.unitTestResults.put(fileName, testResults);
        }
        LOG.debug("Added Test Method: {} to File: {}", (Object)methodFullName, (Object)fileName);
    }

    protected String extractDllNameFromFilePath(String filePath) {
        return filePath.substring(filePath.lastIndexOf(File.separator) + 1, filePath.lastIndexOf(46));
    }

    protected String getFullName(String methodName, String dllName) {
        List<String> separators = List.of("<", "(");
        for (String separator : separators) {
            if (!methodName.contains(separator)) continue;
            methodName = methodName.substring(0, methodName.indexOf(separator));
        }
        if (methodName.contains("`")) {
            String regexPattern = "`\\d+";
            methodName = methodName.replaceAll(regexPattern, "");
        }
        methodName = methodName.replace('+', '.');
        return String.join((CharSequence)".", dllName, methodName);
    }
}

