/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests.coverage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.dotnet.tests.FileService;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;
import org.sonar.plugins.dotnet.tests.coverage.Coverage;
import org.sonar.plugins.dotnet.tests.coverage.CoverageParser;
import org.sonarsource.dotnet.shared.CallableUtils;

public class VisualStudioCoverageXmlReportParser
implements CoverageParser {
    private static final Logger LOG = LoggerFactory.getLogger(VisualStudioCoverageXmlReportParser.class);
    private final FileService fileService;

    public VisualStudioCoverageXmlReportParser(FileService fileService) {
        this.fileService = fileService;
    }

    @Override
    public void accept(File file, Coverage coverage) {
        LOG.debug("The current user dir is '{}'.", CallableUtils.lazy(() -> System.getProperty("user.dir")));
        LOG.info("Parsing the Visual Studio coverage XML report {}", (Object)file.getAbsolutePath());
        new Parser(file, coverage).parse();
    }

    private class Parser {
        private final File file;
        private final Map<Integer, List<Integer>> coveredLines = new HashMap<Integer, List<Integer>>();
        private final Map<Integer, List<Integer>> uncoveredLines = new HashMap<Integer, List<Integer>>();
        private final Coverage coverage;

        Parser(File file, Coverage coverage) {
            this.file = file;
            this.coverage = coverage;
        }

        public void parse() {
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                this.checkRootTag(xmlParserHelper);
                this.dispatchTags(xmlParserHelper);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private void dispatchTags(XmlParserHelper xmlParserHelper) {
            String tagName;
            while ((tagName = xmlParserHelper.nextStartTag()) != null) {
                if ("module".equals(tagName)) {
                    this.handleModuleTag();
                    continue;
                }
                if ("range".equals(tagName)) {
                    this.handleRangeTag(xmlParserHelper);
                    continue;
                }
                if (!"source_file".equals(tagName)) continue;
                this.handleSourceFileTag(xmlParserHelper);
            }
        }

        private void handleModuleTag() {
            this.coveredLines.clear();
            this.uncoveredLines.clear();
        }

        private void handleRangeTag(XmlParserHelper xmlParserHelper) {
            int source = xmlParserHelper.getRequiredIntAttribute("source_id");
            String covered = xmlParserHelper.getRequiredAttribute("covered");
            int line = xmlParserHelper.getRequiredIntAttribute("start_line");
            if ("yes".equals(covered) || "partial".equals(covered)) {
                this.coveredLines.putIfAbsent(source, new ArrayList());
                this.coveredLines.get(source).add(line);
            } else if ("no".equals(covered)) {
                this.uncoveredLines.putIfAbsent(source, new ArrayList());
                this.uncoveredLines.get(source).add(line);
            } else {
                throw xmlParserHelper.parseError("Unsupported \"covered\" value \"" + covered + "\", expected one of \"yes\", \"partial\" or \"no\"");
            }
        }

        private void handleSourceFileTag(XmlParserHelper xmlParserHelper) {
            String canonicalPath;
            int id = xmlParserHelper.getRequiredIntAttribute("id");
            String path = xmlParserHelper.getRequiredAttribute("path");
            try {
                canonicalPath = new File(path).getCanonicalPath();
            }
            catch (IOException e) {
                LOG.warn("Skipping the import of Visual Studio XML code coverage for the invalid file path: " + path + " at line " + xmlParserHelper.stream().getLocation().getLineNumber(), (Throwable)e);
                return;
            }
            if (!VisualStudioCoverageXmlReportParser.this.fileService.isSupportedAbsolute(canonicalPath)) {
                Optional<String> absolutePath = VisualStudioCoverageXmlReportParser.this.fileService.getAbsolutePath(path);
                if (absolutePath.isPresent()) {
                    canonicalPath = absolutePath.get();
                    LOG.debug("Found indexed file '{}' for coverage entry '{}'.", (Object)canonicalPath, (Object)path);
                } else {
                    return;
                }
            }
            if (this.coveredLines.containsKey(id)) {
                LOG.trace("Found covered lines for id '{}' for path '{}'", (Object)id, (Object)canonicalPath);
                for (Integer line : this.coveredLines.get(id)) {
                    this.coverage.addHits(canonicalPath, line, 1);
                }
            }
            if (this.uncoveredLines.containsKey(id)) {
                LOG.trace("Found uncovered lines for id '{}' for path '{}'", (Object)id, (Object)canonicalPath);
                for (Integer line : this.uncoveredLines.get(id)) {
                    this.coverage.addHits(canonicalPath, line, 0);
                }
            }
        }

        private void checkRootTag(XmlParserHelper xmlParserHelper) {
            xmlParserHelper.checkRootTag("results");
        }
    }
}

