/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Configuration;
import org.sonarsource.dotnet.shared.CallableUtils;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

@ScannerSide
@InstantiationStrategy(value="PER_PROJECT")
public class ModuleConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleConfiguration.class);
    private static final String MSG_SUFFIX = "Analyzer results won't be loaded from this directory.";
    private final Configuration configuration;
    private final String projectKey;
    private final PluginMetadata metadata;

    public ModuleConfiguration(Configuration configuration, PluginMetadata metadata) {
        this.configuration = configuration;
        this.metadata = metadata;
        this.projectKey = configuration.get("sonar.projectKey").orElse("<NONE>");
        LOG.trace("Project '{}': AbstractModuleConfiguration has been created.", (Object)this.projectKey);
    }

    static String getAnalyzerReportDir(String languageKey) {
        return "output-" + languageKey;
    }

    public List<Path> protobufReportPaths() {
        List<Path> analyzerWorkDirPaths = Arrays.stream(this.configuration.getStringArray(AbstractPropertyDefinitions.getAnalyzerWorkDirProperty(this.metadata.languageKey()))).map(x$0 -> Paths.get(x$0, new String[0])).toList();
        if (analyzerWorkDirPaths.isEmpty() && !this.configuration.hasKey("sonar.tests")) {
            LOG.debug("Project '{}': Property missing: '{}'. No protobuf files will be loaded for this project.", (Object)this.projectKey, CallableUtils.lazy(() -> AbstractPropertyDefinitions.getAnalyzerWorkDirProperty(this.metadata.languageKey())));
        }
        return analyzerWorkDirPaths.stream().map(x -> x.resolve(ModuleConfiguration.getAnalyzerReportDir(this.metadata.languageKey()))).filter(this::validateOutputDir).toList();
    }

    public List<Path> roslynReportPaths() {
        String[] strPaths = this.configuration.getStringArray(AbstractPropertyDefinitions.getRoslynJsonReportPathProperty(this.metadata.languageKey()));
        if (strPaths.length > 0) {
            LOG.debug("Project '{}': The Roslyn JSON report path has '{}'", (Object)this.projectKey, CallableUtils.lazy(() -> String.join((CharSequence)",", strPaths)));
            return Arrays.stream(strPaths).map(x$0 -> Paths.get(x$0, new String[0])).toList();
        }
        LOG.debug("Project '{}': No Roslyn issues reports have been found.", (Object)this.projectKey);
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateOutputDir(Path analyzerOutputDir) {
        String path = analyzerOutputDir.toString();
        try {
            if (!analyzerOutputDir.toFile().exists()) {
                LOG.debug("Project '{}': Analyzer working directory does not exist: '{}'. {}", new Object[]{this.projectKey, path, MSG_SUFFIX});
                return false;
            }
            try (DirectoryStream<Path> files = Files.newDirectoryStream(analyzerOutputDir, ModuleConfiguration.protoFileFilter());){
                long count = StreamSupport.stream(files.spliterator(), false).count();
                if (count == 0L) {
                    LOG.debug("Project '{}': Analyzer working directory '{}' contains no .pb file(s). {}", new Object[]{this.projectKey, path, MSG_SUFFIX});
                    boolean bl2 = false;
                    return bl2;
                }
                LOG.debug("Project '{}': Analyzer working directory '{}' contains {} .pb file(s)", new Object[]{this.projectKey, path, count});
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not check for .pb files in '" + path + "' for project " + this.projectKey, e);
        }
    }

    private static DirectoryStream.Filter<Path> protoFileFilter() {
        return p -> p.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".pb");
    }
}

