/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonarsource.dotnet.shared.CallableUtils;
import org.sonarsource.dotnet.shared.StringUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.CPDTokensImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.HighlightImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.MetricsImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.SymbolRefsImporter;

@ScannerSide
public class ProtobufDataImporter {
    public static final String CPDTOKENS_FILENAME = "token-cpd.pb";
    public static final String FILEMETADATA_FILENAME = "file-metadata.pb";
    public static final String HIGHLIGHT_FILENAME = "token-type.pb";
    public static final String LOG_FILENAME = "log.pb";
    public static final String TELEMETRY_FILENAME = "telemetry.pb";
    public static final String METHODDECLARATIONS_FILENAME = "test-method-declarations.pb";
    public static final String METRICS_FILENAME = "metrics.pb";
    public static final String SYMBOLREFS_FILENAME = "symrefs.pb";
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufDataImporter.class);
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;

    public ProtobufDataImporter(FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
    }

    public void importResults(SensorContext context, List<Path> protobufReportsDirectories, UnaryOperator<String> toRealPath) {
        MetricsImporter metricsImporter = new MetricsImporter(context, this.fileLinesContextFactory, this.noSonarFilter, toRealPath);
        HighlightImporter highlightImporter = new HighlightImporter(context, toRealPath);
        SymbolRefsImporter symbolRefsImporter = new SymbolRefsImporter(context, toRealPath);
        CPDTokensImporter cpdTokensImporter = new CPDTokensImporter(context, toRealPath);
        for (Path protobufReportsDir : protobufReportsDirectories) {
            long protoFiles = ProtobufDataImporter.countProtoFiles(protobufReportsDir);
            LOG.info("Importing results from {} proto {} in '{}'", new Object[]{protoFiles, CallableUtils.lazy(() -> StringUtils.pluralize("file", protoFiles)), protobufReportsDir});
            ProtobufDataImporter.parseProtobuf(metricsImporter, protobufReportsDir, METRICS_FILENAME);
            ProtobufDataImporter.parseProtobuf(highlightImporter, protobufReportsDir, HIGHLIGHT_FILENAME);
            ProtobufDataImporter.parseProtobuf(symbolRefsImporter, protobufReportsDir, SYMBOLREFS_FILENAME);
            ProtobufDataImporter.parseProtobuf(cpdTokensImporter, protobufReportsDir, CPDTOKENS_FILENAME);
        }
        metricsImporter.save();
        ((RawProtobufImporter)highlightImporter).save();
        ((RawProtobufImporter)symbolRefsImporter).save();
        cpdTokensImporter.save();
    }

    private static long countProtoFiles(Path dir) {
        long l;
        block8: {
            Stream<Path> stream = Files.list(dir);
            try {
                l = stream.filter(p -> p.getFileName().toString().toLowerCase(Locale.ENGLISH).endsWith(".pb")).count();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("unexpected error while reading files in: " + dir, e);
                }
            }
            stream.close();
        }
        return l;
    }

    public static void parseProtobuf(RawProtobufImporter<?> importer, Path workDirectory, String filename) {
        Path protobuf = workDirectory.resolve(filename);
        if (protobuf.toFile().exists()) {
            importer.accept(protobuf);
        } else {
            LOG.warn("Protobuf file not found: {}", (Object)protobuf);
        }
    }
}

