/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public abstract class RawProtobufImporter<T> {
    private final Parser<T> parser;

    RawProtobufImporter(Parser<T> parser) {
        this.parser = parser;
    }

    public void accept(Path protobuf) {
        try (InputStream inputStream = Files.newInputStream(protobuf, new OpenOption[0]);){
            T message;
            while ((message = this.parser.parseDelimitedFrom(inputStream)) != null) {
                this.consume(message);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("unexpected error while parsing protobuf file: " + protobuf, e);
        }
    }

    abstract void consume(T var1);

    public void save() {
    }
}

