/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.symbol.NewSymbol;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporter;

public class SymbolRefsImporter
extends ProtobufImporter<SonarAnalyzer.SymbolReferenceInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolRefsImporter.class);
    private final SensorContext context;
    private final HashMap<InputFile, HashSet<SonarAnalyzer.SymbolReferenceInfo.SymbolReference>> fileSymbolReferences = new HashMap();

    public SymbolRefsImporter(SensorContext context, UnaryOperator<String> toRealPath) {
        super(SonarAnalyzer.SymbolReferenceInfo.parser(), context, SonarAnalyzer.SymbolReferenceInfo::getFilePath, toRealPath);
        this.context = context;
    }

    private static void addReferences(InputFile file, SonarAnalyzer.SymbolReferenceInfo.SymbolReference tokenInfo, NewSymbolTable symbolTable) {
        Optional<TextRange> declarationRange = SensorContextUtils.toTextRange(file, tokenInfo.getDeclaration());
        if (declarationRange.isPresent()) {
            NewSymbol symbol = symbolTable.newSymbol(declarationRange.get());
            for (SonarAnalyzer.TextRange refTextRange : tokenInfo.getReferenceList()) {
                Optional<TextRange> validatedReference = SymbolRefsImporter.validatedReference(file, refTextRange, declarationRange.get());
                validatedReference.ifPresent(arg_0 -> ((NewSymbol)symbol).newReference(arg_0));
            }
        }
    }

    private static Optional<TextRange> validatedReference(InputFile file, SonarAnalyzer.TextRange refTextRange, TextRange declarationRange) {
        Optional<TextRange> referenceRange = SensorContextUtils.toTextRange(file, refTextRange);
        if (referenceRange.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The reported token was out of the range. File {}, Range {}", (Object)file.filename(), (Object)refTextRange);
            }
            return Optional.empty();
        }
        if (declarationRange.overlap(referenceRange.get())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("The declaration token at {} overlaps with the referencing token {} in file {}", new Object[]{declarationRange, referenceRange.get(), file.filename()});
            }
            return Optional.empty();
        }
        return referenceRange;
    }

    @Override
    void consumeFor(InputFile inputFile, SonarAnalyzer.SymbolReferenceInfo message) {
        for (SonarAnalyzer.SymbolReferenceInfo.SymbolReference tokenInfo : message.getReferenceList()) {
            this.fileSymbolReferences.computeIfAbsent(inputFile, f -> new HashSet()).add(tokenInfo);
        }
    }

    @Override
    public void save() {
        for (Map.Entry<InputFile, HashSet<SonarAnalyzer.SymbolReferenceInfo.SymbolReference>> entry : this.fileSymbolReferences.entrySet()) {
            NewSymbolTable symbolTable = this.context.newSymbolTable().onFile(entry.getKey());
            for (SonarAnalyzer.SymbolReferenceInfo.SymbolReference tokenInfo : entry.getValue()) {
                SymbolRefsImporter.addReferences(entry.getKey(), tokenInfo, symbolTable);
            }
            symbolTable.save();
        }
    }

    @Override
    boolean isProcessed(InputFile inputFile) {
        return false;
    }
}

