/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.sensors;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonarsource.dotnet.shared.CallableUtils;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.ProjectTypeCollector;
import org.sonarsource.dotnet.shared.plugins.ProtobufDataImporter;
import org.sonarsource.dotnet.shared.plugins.RealPathProvider;
import org.sonarsource.dotnet.shared.plugins.ReportPathCollector;
import org.sonarsource.dotnet.shared.plugins.RoslynDataImporter;
import org.sonarsource.dotnet.shared.plugins.RoslynProfileExporter;
import org.sonarsource.dotnet.shared.plugins.RoslynReport;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;

public class DotNetSensor
implements ProjectSensor {
    private static final Logger LOG = LoggerFactory.getLogger(DotNetSensor.class);
    private static final String GET_HELP_MESSAGE = "You can get help on the community forum: https://community.sonarsource.com";
    private static final String READ_MORE_MESSAGE = "Read more about how the SonarScanner for .NET detects test projects: https://github.com/SonarSource/sonar-scanner-msbuild/wiki/Analysis-of-product-projects-vs.-test-projects";
    private final ProtobufDataImporter protobufDataImporter;
    private final RoslynDataImporter roslynDataImporter;
    private final PluginMetadata pluginMetadata;
    private final ReportPathCollector reportPathCollector;
    private final ProjectTypeCollector projectTypeCollector;
    private final AnalysisWarnings analysisWarnings;

    public DotNetSensor(PluginMetadata pluginMetadata, ReportPathCollector reportPathCollector, ProjectTypeCollector projectTypeCollector, ProtobufDataImporter protobufDataImporter, RoslynDataImporter roslynDataImporter, AnalysisWarnings analysisWarnings) {
        this.pluginMetadata = pluginMetadata;
        this.reportPathCollector = reportPathCollector;
        this.projectTypeCollector = projectTypeCollector;
        this.protobufDataImporter = protobufDataImporter;
        this.roslynDataImporter = roslynDataImporter;
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name(this.pluginMetadata.languageName()).onlyOnLanguage(this.pluginMetadata.languageKey());
    }

    public void execute(SensorContext context) {
        FileSystem fs = context.fileSystem();
        boolean hasFilesOfLanguage = SensorContextUtils.hasFilesOfLanguage(fs, this.pluginMetadata.languageKey());
        boolean hasProjects = this.projectTypeCollector.hasProjects();
        if (hasFilesOfLanguage && hasProjects) {
            this.importResults(fs, context);
        } else {
            this.log(hasFilesOfLanguage, hasProjects);
        }
        this.projectTypeCollector.getSummary(this.pluginMetadata.languageName()).ifPresent(arg_0 -> ((Logger)LOG).info(arg_0));
    }

    private void importResults(FileSystem fs, SensorContext context) {
        List<Path> protobufPaths;
        boolean hasMainFiles = SensorContextUtils.hasFilesOfType(fs, InputFile.Type.MAIN, this.pluginMetadata.languageKey());
        boolean hasTestFiles = SensorContextUtils.hasFilesOfType(fs, InputFile.Type.TEST, this.pluginMetadata.languageKey());
        RealPathProvider toRealPath = new RealPathProvider();
        if (hasTestFiles && !hasMainFiles) {
            DotNetSensor.warnThatProjectContainsOnlyTestCode(fs, this.analysisWarnings, this.pluginMetadata.languageName());
        }
        if ((protobufPaths = this.reportPathCollector.protobufDirs()).isEmpty()) {
            LOG.warn("No protobuf reports found. The {} files will not have highlighting and metrics. {}", CallableUtils.lazy(this.pluginMetadata::languageName), (Object)GET_HELP_MESSAGE);
        } else {
            this.protobufDataImporter.importResults(context, protobufPaths, toRealPath);
        }
        List<RoslynReport> roslynReports = this.reportPathCollector.roslynReports();
        if (roslynReports.isEmpty()) {
            LOG.warn("No Roslyn issue reports were found. The {} files have not been analyzed. {}", CallableUtils.lazy(this.pluginMetadata::languageName), (Object)GET_HELP_MESSAGE);
        } else {
            Map<String, List<RuleKey>> activeRoslynRulesByPartialRepoKey = RoslynProfileExporter.activeRoslynRulesByPartialRepoKey(this.pluginMetadata, context.activeRules().findAll().stream().map(ActiveRule::ruleKey).toList());
            this.roslynDataImporter.importRoslynReports(roslynReports, context, activeRoslynRulesByPartialRepoKey, toRealPath);
        }
    }

    private void log(boolean hasFilesOfLanguage, boolean hasProjects) {
        if (hasProjects) {
            assert (!hasFilesOfLanguage);
        } else if (hasFilesOfLanguage) {
            LOG.warn("Your project contains {} files which cannot be analyzed with the scanner you are using. To analyze C# or VB.NET, you must use the SonarScanner for .NET 5.x or higher, see https://redirect.sonarsource.com/doc/install-configure-scanner-msbuild.html", CallableUtils.lazy(this.pluginMetadata::languageName));
        }
        if (!hasFilesOfLanguage) {
            DotNetSensor.logDebugNoFiles();
        }
    }

    private static void warnThatProjectContainsOnlyTestCode(FileSystem fs, AnalysisWarnings analysisWarnings, String languageName) {
        LOG.warn("SonarScanner for .NET detected only TEST files and no MAIN files for {} in the current solution. Only TEST-code related results will be imported to your SonarQube project. Many of our rules (e.g. vulnerabilities) are raised only on MAIN-code. {}", (Object)languageName, (Object)READ_MORE_MESSAGE);
        if (!SensorContextUtils.hasAnyMainFiles(fs)) {
            analysisWarnings.addUnique(String.format("Your project contains only TEST-code for language %s and no MAIN-code for any language, so only TEST-code related results are imported. Many of our rules (e.g. vulnerabilities) are raised only on MAIN-code. %s", languageName, READ_MORE_MESSAGE));
        }
    }

    private static void logDebugNoFiles() {
        LOG.debug("No files to analyze. Skip Sensor.");
    }
}

