/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.symbol.NewSymbol;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporter;

class SymbolRefsImporter
extends ProtobufImporter<SonarAnalyzer.SymbolReferenceInfo> {
    private final SensorContext context;
    private final HashMap<InputFile, HashSet<SonarAnalyzer.SymbolReferenceInfo.SymbolReference>> fileSymbolReferences = new HashMap();

    SymbolRefsImporter(SensorContext context, UnaryOperator<String> toRealPath) {
        super(SonarAnalyzer.SymbolReferenceInfo.parser(), context, SonarAnalyzer.SymbolReferenceInfo::getFilePath, toRealPath);
        this.context = context;
    }

    @Override
    void consumeFor(InputFile inputFile, SonarAnalyzer.SymbolReferenceInfo message) {
        for (SonarAnalyzer.SymbolReferenceInfo.SymbolReference tokenInfo : message.getReferenceList()) {
            this.fileSymbolReferences.computeIfAbsent(inputFile, f -> new HashSet()).add(tokenInfo);
        }
    }

    @Override
    public void save() {
        for (Map.Entry<InputFile, HashSet<SonarAnalyzer.SymbolReferenceInfo.SymbolReference>> entry : this.fileSymbolReferences.entrySet()) {
            NewSymbolTable symbolTable = this.context.newSymbolTable().onFile(entry.getKey());
            for (SonarAnalyzer.SymbolReferenceInfo.SymbolReference tokenInfo : entry.getValue()) {
                NewSymbol symbol = symbolTable.newSymbol(SensorContextUtils.toTextRange(entry.getKey(), tokenInfo.getDeclaration()));
                for (SonarAnalyzer.TextRange refTextRange : tokenInfo.getReferenceList()) {
                    symbol.newReference(SensorContextUtils.toTextRange(entry.getKey(), refTextRange));
                }
            }
            symbolTable.save();
        }
    }

    @Override
    boolean isProcessed(InputFile inputFile) {
        return false;
    }
}

