/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;
import org.sonar.flex.checks.utils.Clazz;

@Rule(key="S1186")
public class EmptyMethodCheck
extends FlexCheck {
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    public void visitNode(AstNode astNode) {
        for (AstNode function : Clazz.getFunctions(astNode)) {
            AstNode block = function.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK});
            if (block == null || !EmptyMethodCheck.isEmptyBlock(block)) continue;
            this.addIssue("Add a nested comment explaining why this method is empty, throw an NotSupportedException or complete the implementation.", function);
        }
    }

    private static boolean isEmptyBlock(AstNode block) {
        AstNode rightCurlyBrace = block.getFirstChild(new AstNodeType[]{FlexPunctuator.RCURLYBRACE});
        return !block.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).hasChildren() && !EmptyMethodCheck.hasComment(rightCurlyBrace);
    }

    private static boolean hasComment(AstNode node) {
        return node.getToken().hasTrivia();
    }
}

