/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Variable;

@Rule(key="S116")
public class FieldNameCheck
extends FlexCheck {
    private static final String DEFAULT = "^[_a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the field names against", defaultValue="^[_a-z][a-zA-Z0-9]*$")
    String format = "^[_a-z][a-zA-Z0-9]*$";

    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    public void visitNode(AstNode astNode) {
        for (AstNode directive : Clazz.getDirectives(astNode)) {
            if (!Variable.isVariable(directive)) continue;
            AstNode variableDeclStatement = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT});
            this.visitVariableDeclStatement(variableDeclStatement);
        }
    }

    private void visitVariableDeclStatement(AstNode variableDeclStatement) {
        for (AstNode identifier : Variable.getDeclaredIdentifiers(variableDeclStatement)) {
            if (this.pattern.matcher(identifier.getTokenValue()).matches()) continue;
            this.addIssue(MessageFormat.format("Rename this field name to match the regular expression {0}", this.format), identifier);
        }
    }
}

