/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="FunctionSinglePointOfExit")
public class FunctionSinglePointOfExitCheck
extends FlexCheck {
    private int returnStatements;

    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.FUNCTION_DEF, FlexGrammar.RETURN_STATEMENT);
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF})) {
            this.returnStatements = 0;
        } else if (node.is(new AstNodeType[]{FlexGrammar.RETURN_STATEMENT})) {
            ++this.returnStatements;
        }
    }

    public void leaveNode(AstNode node) {
        if (node.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}) && this.returnStatements != 0 && (this.returnStatements > 1 || !FunctionSinglePointOfExitCheck.hasReturnAtEnd(node))) {
            this.addIssue("A function shall have a single point of exit at the end of the function.", node);
        }
    }

    private static boolean hasReturnAtEnd(AstNode functionDefinitionNode) {
        AstNode statementNode;
        AstNode lastDirectiveNode = functionDefinitionNode.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getLastChild();
        return lastDirectiveNode != null && (statementNode = lastDirectiveNode.getFirstChild(new AstNodeType[]{FlexGrammar.STATEMENT})) != null && statementNode.getFirstChild().is(new AstNodeType[]{FlexGrammar.RETURN_STATEMENT});
    }
}

