/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="S107")
public class FunctionWithTooManyParametersCheck
extends FlexCheck {
    private static final int DEFAULT = 7;
    @RuleProperty(key="max", description="Maximum authorized number of parameters", defaultValue="7")
    int max = 7;

    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.PARAMETERS);
    }

    public void visitNode(AstNode astNode) {
        int nbParameters = astNode.getChildren(new AstNodeType[]{FlexGrammar.PARAMETER, FlexGrammar.REST_PARAMETERS}).size();
        if (nbParameters > this.max) {
            this.addIssue(MessageFormat.format("This function has {0,number,integer} parameters, which is greater than the {1,number,integer} authorized.", nbParameters, this.max), astNode);
        }
    }
}

