/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="S1821")
public class NestedSwitchCheck
extends FlexCheck {
    private int switchLevel = 0;

    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.SWITCH_STATEMENT);
    }

    public void leaveFile(@Nullable AstNode astNode) {
        this.switchLevel = 0;
    }

    public void visitNode(AstNode astNode) {
        ++this.switchLevel;
        if (this.switchLevel > 1) {
            this.addIssue("Move this \"switch\" to a function or refactor the code to eliminate it.", astNode);
        }
    }

    public void leaveNode(AstNode astNode) {
        --this.switchLevel;
    }
}

