/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.List;

public class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areEquivalent(AstNode node1, AstNode node2) {
        if (!node1.getType().equals(node2.getType()) || node1.getNumberOfChildren() != node2.getNumberOfChildren()) {
            return false;
        }
        if (node1.getNumberOfChildren() == 0) {
            Token token1 = node1.getToken();
            Token token2 = node2.getToken();
            return token1 == null && token2 == null || token1 != null && token2 != null && token1.getValue().equals(token2.getValue());
        }
        List children1 = node1.getChildren();
        List children2 = node2.getChildren();
        for (int i = 0; i < children1.size(); ++i) {
            if (SyntacticEquivalence.areEquivalent((AstNode)children1.get(i), (AstNode)children2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areEquivalent(List<AstNode> list1, List<AstNode> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (SyntacticEquivalence.areEquivalent(list1.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }
}

