/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.utils;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.List;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Preconditions;

public class Function {
    private Function() {
    }

    public static String getName(AstNode functionDef) {
        Preconditions.checkState(functionDef.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}));
        return functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_NAME}).getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}).getTokenValue();
    }

    public static boolean isAccessor(AstNode functionDef) {
        Preconditions.checkState(functionDef.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}));
        return functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_NAME}).getFirstChild(new AstNodeType[]{FlexKeyword.GET, FlexKeyword.SET}) != null;
    }

    public static boolean isEmptyConstructor(AstNode functionDef, String className) {
        Preconditions.checkState(functionDef.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}));
        AstNode functionBlock = functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK});
        return Function.isConstructor(functionDef, className) && (functionBlock == null || functionBlock.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren().isEmpty());
    }

    public static boolean isConstructor(AstNode functionDef, String className) {
        Preconditions.checkState(functionDef.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}));
        return functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_NAME}).getNumberOfChildren() == 1 && functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_NAME}).getFirstChild().getTokenValue().equals(className);
    }

    public static List<AstNode> getParametersIdentifiers(AstNode functionDef) {
        Preconditions.checkState(functionDef.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR}));
        ArrayList<AstNode> paramIdentifier = new ArrayList<AstNode>();
        AstNode parameters = functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_SIGNATURE}).getFirstChild(new AstNodeType[]{FlexGrammar.PARAMETERS});
        if (parameters != null) {
            for (AstNode parameter : parameters.getChildren(new AstNodeType[]{FlexGrammar.PARAMETER, FlexGrammar.REST_PARAMETERS})) {
                if (parameter.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}) == null) continue;
                paramIdentifier.add(parameter.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}));
            }
        }
        return paramIdentifier;
    }

    public static boolean isOverriding(AstNode functionDef) {
        Preconditions.checkState(functionDef.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}));
        AstNode attributesNode = functionDef.getPreviousAstNode();
        if (attributesNode != null && attributesNode.is(new AstNodeType[]{FlexGrammar.ATTRIBUTES})) {
            for (AstNode attribute : attributesNode.getChildren()) {
                if (!attribute.getFirstChild().is(new AstNodeType[]{FlexGrammar.ATTRIBUTE_EXPR}) || attribute.getFirstChild().getNumberOfChildren() != 1 || !attribute.getFirstChild().getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}).getTokenValue().equals(FlexKeyword.OVERRIDE.getValue())) continue;
                return true;
            }
        }
        return false;
    }
}

