/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.utils;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Preconditions;

public final class MetadataTag {
    private MetadataTag() {
    }

    public static boolean isTag(AstNode metadata, String tagName) {
        Preconditions.checkState(metadata.is(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT}));
        if (MetadataTag.isNotEmpty(metadata)) {
            AstNode postfixExpr = metadata.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR});
            return postfixExpr != null && tagName.equals(postfixExpr.getTokenValue());
        }
        return false;
    }

    public static List<String> getSinglePropertyAsList(AstNode metadata) {
        AstNode properties;
        Preconditions.checkState(metadata.is(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT}));
        ArrayList<String> propertyList = new ArrayList<String>();
        if (MetadataTag.isNotEmpty(metadata) && MetadataTag.hasProperty(metadata) && (properties = metadata.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.ARGUMENTS}).getFirstChild(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION})).getNumberOfChildren() == 1) {
            AstNode assignmentExpr = properties.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR});
            if (assignmentExpr.getNumberOfChildren() > 1) {
                assignmentExpr = assignmentExpr.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR});
            }
            String singleProperty = assignmentExpr.getTokenValue();
            for (String property : singleProperty.substring(1, singleProperty.length() - 1).split(",")) {
                propertyList.add(property.trim());
            }
        }
        return propertyList;
    }

    public static Map<String, String> getTagPropertiesMap(AstNode metadata) {
        Preconditions.checkState(metadata.is(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT}));
        if (MetadataTag.isNotEmpty(metadata) && MetadataTag.hasProperty(metadata)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            AstNode listExpr = metadata.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.ARGUMENTS}).getFirstChild(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION});
            for (AstNode assignmentExpr : listExpr.getChildren(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR})) {
                if (assignmentExpr.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_OPERATOR}) == null) continue;
                properties.put(assignmentExpr.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_OPERATOR}).getPreviousSibling().getTokenValue(), assignmentExpr.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_OPERATOR}).getNextSibling().getTokenValue());
            }
            return properties;
        }
        return null;
    }

    public static boolean isNotEmpty(AstNode metadata) {
        return metadata.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR}) != null && metadata.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR}) != null;
    }

    public static boolean hasProperty(AstNode metadata) {
        Preconditions.checkState(metadata.is(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT}));
        AstNode arguments = metadata.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.ARGUMENTS});
        return arguments != null && arguments.getFirstChild(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION}) != null;
    }

    public static boolean isMetadataTag(AstNode directive) {
        return directive.getFirstChild().is(new AstNodeType[]{FlexGrammar.STATEMENT}) && directive.getFirstChild().getFirstChild().is(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT});
    }
}

