/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.flex.FlexVisitorContext;

public abstract class FlexVisitor {
    private FlexVisitorContext context;
    private Set<AstNodeType> subscribedKinds = null;

    public abstract List<AstNodeType> subscribedTo();

    private Set<AstNodeType> subscribedKinds() {
        if (this.subscribedKinds == null) {
            this.subscribedKinds = Collections.unmodifiableSet(new HashSet<AstNodeType>(this.subscribedTo()));
        }
        return this.subscribedKinds;
    }

    public void visitFile(@Nullable AstNode node) {
    }

    public void leaveFile(@Nullable AstNode node) {
    }

    public void visitNode(AstNode node) {
    }

    public void leaveNode(AstNode node) {
    }

    public void visitToken(Token token) {
    }

    public FlexVisitorContext getContext() {
        return this.context;
    }

    public void scanFile(FlexVisitorContext context) {
        this.context = context;
        AstNode tree = context.rootTree();
        this.visitFile(tree);
        if (tree != null) {
            this.scanNode(tree);
        }
        this.leaveFile(tree);
    }

    public void scanNode(AstNode node) {
        List<AstNode> children;
        boolean isSubscribedType = this.subscribedKinds().contains(node.getType());
        if (isSubscribedType) {
            this.visitNode(node);
        }
        if ((children = node.getChildren()).isEmpty()) {
            node.getTokens().forEach(this::visitToken);
        } else {
            children.forEach(this::scanNode);
        }
        if (isSubscribedType) {
            this.leaveNode(node);
        }
    }
}

