/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;

@Rule(key="S1442")
public class AlertShowUseCheck
extends FlexCheck {
    private static final State[][] TRANSITIONS = new State[State.values().length][Symbol.values().length];
    private State currentState;

    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    @Override
    public void visitFile(@Nullable AstNode node) {
        this.currentState = State.EXPECTING_ALERT;
    }

    @Override
    public void visitToken(Token token) {
        this.currentState = TRANSITIONS[this.currentState.ordinal()][AlertShowUseCheck.getSymbol(token.getOriginalValue()).ordinal()];
        if (this.currentState == State.FOUND_ISSUE) {
            this.addIssue("Remove this usage of Alert.show().", token);
            this.currentState = State.EXPECTING_ALERT;
        }
    }

    private static Symbol getSymbol(String value) {
        Symbol result = Symbol.OTHER;
        if (".".equals(value)) {
            result = Symbol.DOT;
        } else if ("Alert".equals(value)) {
            result = Symbol.ALERT;
        } else if ("show".equals(value)) {
            result = Symbol.SHOW;
        }
        return result;
    }

    static {
        for (int i = 0; i < TRANSITIONS.length; ++i) {
            for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                AlertShowUseCheck.TRANSITIONS[i][j] = State.EXPECTING_ALERT;
            }
        }
        AlertShowUseCheck.TRANSITIONS[State.EXPECTING_ALERT.ordinal()][Symbol.ALERT.ordinal()] = State.EXPECTING_DOT;
        AlertShowUseCheck.TRANSITIONS[State.EXPECTING_DOT.ordinal()][Symbol.DOT.ordinal()] = State.EXPECTING_SHOW;
        AlertShowUseCheck.TRANSITIONS[State.EXPECTING_SHOW.ordinal()][Symbol.SHOW.ordinal()] = State.FOUND_ISSUE;
    }

    private static enum State {
        EXPECTING_ALERT,
        EXPECTING_DOT,
        EXPECTING_SHOW,
        FOUND_ISSUE;

    }

    private static enum Symbol {
        OTHER,
        ALERT,
        DOT,
        SHOW;

    }
}

