/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.flex.checks.ConditionalStructure;
import org.sonar.flex.checks.ConditionalStructureCheckBase;

@Rule(key="S1871")
public class DuplicateBranchImplementationCheck
extends ConditionalStructureCheckBase {
    AstNode prevBranch1 = null;

    @Override
    public void visitConditionalStructure(ConditionalStructure cond) {
        this.prevBranch1 = null;
        cond.forEachBranchDuplication((branch1, branch2) -> {
            if (branch1 == this.prevBranch1) {
                return;
            }
            this.prevBranch1 = branch1;
            String message = MessageFormat.format("Either merge this case with the identical one on line \"{0}\" or change one of the implementations.", branch2.getTokenLine());
            this.addIssue(message, branch1);
        });
    }
}

