/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.MetadataTag;

@Rule(key="S1463")
public class EventMetadataShouldBeTypedCheck
extends FlexCheck {
    @Override
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.METADATA_STATEMENT);
    }

    @Override
    public void visitNode(AstNode astNode) {
        Map<String, String> properties;
        if (MetadataTag.isTag(astNode, "Event") && (properties = MetadataTag.getTagPropertiesMap(astNode)) != null && !properties.containsKey("type")) {
            this.addIssue(MessageFormat.format("The {0} event type is missing in this metadata tag", properties.get("name")), astNode);
        }
    }
}

