/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.channel;

import java.util.ArrayList;
import java.util.List;
import org.sonar.sslr.channel.Channel;
import org.sonar.sslr.channel.CodeReader;

public class ChannelDispatcher<O>
extends Channel<O> {
    private final boolean failIfNoChannelToConsumeOneCharacter;
    private final Channel<O>[] channels;

    private ChannelDispatcher(Builder builder) {
        this.channels = builder.channels.toArray(new Channel[builder.channels.size()]);
        this.failIfNoChannelToConsumeOneCharacter = builder.failIfNoChannelToConsumeOneCharacter;
    }

    @Override
    public boolean consume(CodeReader code, O output) {
        int nextChar = code.peek();
        while (nextChar != -1) {
            boolean characterConsumed = false;
            for (Channel<O> channel : this.channels) {
                if (!channel.consume(code, output)) continue;
                characterConsumed = true;
                break;
            }
            if (!characterConsumed) {
                if (this.failIfNoChannelToConsumeOneCharacter) {
                    String message = "None of the channel has been able to handle character '" + (char)code.peek() + "' (decimal value " + code.peek() + ") at line " + code.getLinePosition() + ", column " + code.getColumnPosition();
                    throw new IllegalStateException(message);
                }
                code.pop();
            }
            nextChar = code.peek();
        }
        return true;
    }

    Channel[] getChannels() {
        return this.channels;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Channel> channels = new ArrayList<Channel>();
        private boolean failIfNoChannelToConsumeOneCharacter = false;

        private Builder() {
        }

        public Builder addChannel(Channel channel) {
            this.channels.add(channel);
            return this;
        }

        public Builder addChannels(Channel ... c) {
            for (Channel channel : c) {
                this.addChannel(channel);
            }
            return this;
        }

        public Builder failIfNoChannelToConsumeOneCharacter() {
            this.failIfNoChannelToConsumeOneCharacter = true;
            return this;
        }

        public <O> ChannelDispatcher<O> build() {
            return new ChannelDispatcher(this);
        }
    }
}

