/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.scripting;

import java.lang.reflect.Method;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.el.lang.ExpressionBuilder;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="UnifiedExpressionCheck")
public class UnifiedExpressionCheck
extends AbstractPageCheck {
    private static final String DEFAULT_FUNCTIONS = "";
    private static final String[] JSTL_FUNCTIONS = new String[]{"contains", "containsIgnoreCase", "endsWith", "escapeXml", "indexOf", "join", "length", "replace", "split", "startsWith", "substring", "substringAfter", "substringBefore", "toLowerCase", "toUpperCase", "trim"};
    @RuleProperty(key="functions", description="Comma-separated list of names of functions", defaultValue="")
    public String functions = "";
    private String[] functionsArray;

    @Override
    public void startDocument(List<Node> nodes) {
        this.functionsArray = StringUtils.stripAll(StringUtils.split(this.functions, ","));
    }

    @Override
    public void startElement(TagNode element) {
        for (Attribute attribute : element.getAttributes()) {
            String value = attribute.getValue();
            if (value == null || (value = value.trim()).length() <= 0 || !this.isUnifiedExpression(value)) continue;
            this.validateExpression(element, attribute);
        }
    }

    private void validateExpression(TagNode element, Attribute attribute) {
        block2: {
            ExpressionLanguageContext context = new ExpressionLanguageContext(element);
            ExpressionBuilder builder = new ExpressionBuilder(attribute.getValue(), context);
            try {
                builder.createValueExpression(Object.class);
            }
            catch (ELException e) {
                if (!e.getMessage().startsWith("Error")) break block2;
                this.createViolation(element.getStartLinePosition(), "Fix this expression: " + (e.getMessage() == null ? DEFAULT_FUNCTIONS : e.getMessage()));
            }
        }
    }

    private class ExpressionLanguageContext
    extends ELContext {
        private final TagNode element;

        public ExpressionLanguageContext(TagNode element) {
            this.element = element;
        }

        @Override
        public ELResolver getELResolver() {
            return null;
        }

        @Override
        public FunctionMapper getFunctionMapper() {
            if (UnifiedExpressionCheck.this.functions.isEmpty()) {
                return null;
            }
            return new FunctionMapper(){

                @Override
                public Method resolveFunction(String prefix, String localName) {
                    if (!ArrayUtils.contains(JSTL_FUNCTIONS, localName) && !ArrayUtils.contains(UnifiedExpressionCheck.this.functionsArray, localName)) {
                        UnifiedExpressionCheck.this.createViolation(ExpressionLanguageContext.this.element.getStartLinePosition(), "Fix this expression: Unknown function \"" + localName + "\".");
                    }
                    return null;
                }
            };
        }

        @Override
        public VariableMapper getVariableMapper() {
            return null;
        }
    }
}

