/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.security;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S5725")
public class ResourceIntegrityCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        Attribute src;
        if (node.equalsElementName("script") && (src = node.getProperty("src")) != null && ResourceIntegrityCheck.isExternal(src.getValue()) && !node.hasProperty("integrity")) {
            this.createViolation(node, "Make sure not using resource integrity feature is safe here.");
        }
    }

    private static boolean isExternal(String srcValue) {
        return srcValue.startsWith("http") || srcValue.startsWith("//");
    }
}

