/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="FieldsetWithoutLegendCheck")
public class FieldsetWithoutLegendCheck
extends AbstractPageCheck {
    private boolean foundLegend;
    private TagNode fieldset;

    @Override
    public void startDocument(List<Node> nodes) {
        this.fieldset = null;
    }

    @Override
    public void startElement(TagNode node) {
        if (FieldsetWithoutLegendCheck.isFieldSet(node)) {
            this.foundLegend = false;
            this.fieldset = node;
        } else if (FieldsetWithoutLegendCheck.isLegend(node)) {
            this.foundLegend = true;
        }
    }

    @Override
    public void endElement(TagNode node) {
        if (FieldsetWithoutLegendCheck.isFieldSet(node)) {
            if (!this.foundLegend && this.fieldset != null) {
                this.createViolation(this.fieldset, "Add a <legend> tag to this fieldset.");
            }
            this.foundLegend = false;
            this.fieldset = null;
        }
    }

    private static boolean isFieldSet(TagNode node) {
        return "FIELDSET".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isLegend(TagNode node) {
        return "LEGEND".equalsIgnoreCase(node.getNodeName());
    }
}

