/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="MouseEventWithoutKeyboardEquivalentCheck")
public class MouseEventWithoutKeyboardEquivalentCheck
extends AbstractPageCheck {
    private static final Pattern KEY_DOWN_WITH_KEY_NAME = Pattern.compile("\\(keydown(\\.\\w{1,10}){1,5}\\)");

    @Override
    public void startElement(TagNode node) {
        if (node.getLocalName().equals(node.getNodeName())) {
            String attribute = null;
            if (MouseEventWithoutKeyboardEquivalentCheck.isException(node)) {
                return;
            }
            if (!(!MouseEventWithoutKeyboardEquivalentCheck.hasOnClick(node) && !MouseEventWithoutKeyboardEquivalentCheck.hasButtonRole(node) || MouseEventWithoutKeyboardEquivalentCheck.hasOnKeyPress(node) || MouseEventWithoutKeyboardEquivalentCheck.hasOnKeyDown(node) || MouseEventWithoutKeyboardEquivalentCheck.hasOnKeyUp(node))) {
                attribute = "onKeyPress|onKeyDown|onKeyUp";
            } else if (MouseEventWithoutKeyboardEquivalentCheck.hasOnMouseover(node) && !MouseEventWithoutKeyboardEquivalentCheck.hasOnFocus(node)) {
                attribute = "onFocus";
            } else if (MouseEventWithoutKeyboardEquivalentCheck.hasOnMouseout(node) && !MouseEventWithoutKeyboardEquivalentCheck.hasOnBlur(node)) {
                attribute = "onBlur";
            }
            if (attribute != null) {
                this.createViolation(node, "Add a '" + attribute + "' attribute to this <" + node.getNodeName() + "> tag.");
            }
        }
    }

    private static boolean isException(TagNode node) {
        return (MouseEventWithoutKeyboardEquivalentCheck.isInput(node) || MouseEventWithoutKeyboardEquivalentCheck.isButton(node) || MouseEventWithoutKeyboardEquivalentCheck.isHyperlink(node)) && MouseEventWithoutKeyboardEquivalentCheck.hasOnClick(node) && !MouseEventWithoutKeyboardEquivalentCheck.hasButtonRole(node);
    }

    private static boolean hasOnClick(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "CLICK");
    }

    private static boolean hasOnKeyPress(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "KEYPRESS");
    }

    private static boolean hasOnKeyDown(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "KEYDOWN") || MouseEventWithoutKeyboardEquivalentCheck.hasAngularKeyDownWithKeyName(node);
    }

    private static boolean hasOnKeyUp(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "KEYUP");
    }

    private static boolean hasOnMouseover(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "MOUSEOVER");
    }

    private static boolean hasOnFocus(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "FOCUS");
    }

    private static boolean hasOnMouseout(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "ONMOUSEOUT") || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "(MOUSEOUT)") || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "ON-MOUSEOUT") || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "NG-MOUSELEAVE");
    }

    private static boolean hasOnBlur(TagNode node) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasEventHandlerAttribute(node, "BLUR");
    }

    private static boolean hasEventHandlerAttribute(TagNode node, String eventName) {
        return MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "ON" + eventName) || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "(" + eventName + ")") || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "ON-" + eventName) || MouseEventWithoutKeyboardEquivalentCheck.hasAttribute(node, "NG-" + eventName);
    }

    private static boolean hasAttribute(TagNode node, String attributeName) {
        return node.getAttribute(attributeName) != null;
    }

    private static boolean hasButtonRole(TagNode node) {
        return "BUTTON".equalsIgnoreCase(node.getPropertyValue("role"));
    }

    private static boolean isInput(TagNode node) {
        return "INPUT".equalsIgnoreCase(node.getNodeName()) && ("BUTTON".equalsIgnoreCase(node.getPropertyValue("type")) || "SUBMIT".equalsIgnoreCase(node.getPropertyValue("type")));
    }

    private static boolean isButton(TagNode node) {
        return "BUTTON".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isHyperlink(TagNode node) {
        return "A".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasAngularKeyDownWithKeyName(TagNode node) {
        return node.getAttributes().stream().anyMatch(a -> KEY_DOWN_WITH_KEY_NAME.matcher(a.getName()).find());
    }
}

