/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="PageWithoutFaviconCheck")
public class PageWithoutFaviconCheck
extends AbstractPageCheck {
    private int currentHeadTagLine;
    private boolean foundTitleTag;

    @Override
    public void startDocument(List<Node> nodes) {
        this.currentHeadTagLine = 0;
    }

    @Override
    public void startElement(TagNode node) {
        if (PageWithoutFaviconCheck.isHeadTag(node)) {
            this.currentHeadTagLine = node.getStartLinePosition();
            this.foundTitleTag = false;
        } else if (this.currentHeadTagLine != 0 && PageWithoutFaviconCheck.isFaviconTag(node)) {
            this.foundTitleTag = true;
        }
    }

    @Override
    public void endElement(TagNode node) {
        int line = 0;
        if (PageWithoutFaviconCheck.isHeadTag(node)) {
            line = this.currentHeadTagLine;
            this.currentHeadTagLine = 0;
        }
        if (!this.foundTitleTag && line != 0) {
            this.createViolation(line, "Add a 'favicon' declaration in this 'header' tag.");
        }
    }

    private static boolean isHeadTag(TagNode node) {
        return "HEAD".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isFaviconTag(TagNode node) {
        String rel = node.getPropertyValue("REL");
        return PageWithoutFaviconCheck.isLinkTag(node) && rel != null && ("ICON".equalsIgnoreCase(rel) || "SHORTCUT ICON".equalsIgnoreCase(rel));
    }

    private static boolean isLinkTag(TagNode node) {
        return "LINK".equalsIgnoreCase(node.getNodeName());
    }
}

