/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="S5256")
public class TableWithoutHeaderCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (TableWithoutHeaderCheck.isTable(node) && !TableWithoutHeaderCheck.isLayout(node) && !TableWithoutHeaderCheck.isHidden(node) && !TableWithoutHeaderCheck.hasHeader(node)) {
            this.createViolation(node, "Add \"<th>\" headers to this \"<table>\".");
        }
    }

    private static boolean isTable(TagNode node) {
        return "TABLE".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean isLayout(TagNode node) {
        String role = node.getAttribute("role");
        return role != null && ("PRESENTATION".equalsIgnoreCase(role) || "NONE".equalsIgnoreCase(role));
    }

    private static boolean isHidden(TagNode node) {
        String ariaHidden = node.getAttribute("aria-hidden");
        return ariaHidden != null && "TRUE".equalsIgnoreCase(ariaHidden);
    }

    private static boolean hasHeader(TagNode node) {
        return node.getChildren().stream().anyMatch(TableWithoutHeaderCheck::isTableHeader) || node.getChildren().stream().filter(child -> !TableWithoutHeaderCheck.isTable(child)).anyMatch(TableWithoutHeaderCheck::hasHeader);
    }

    private static boolean isTableHeader(TagNode node) {
        return "TH".equalsIgnoreCase(node.getNodeName());
    }
}

