/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.checks.sonar.FlashHelper;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="WmodeIsWindowCheck")
public class WmodeIsWindowCheck
extends AbstractPageCheck {
    private static final String WMODE = "WMODE";

    @Override
    public void startElement(TagNode node) {
        int line = 0;
        if (WmodeIsWindowCheck.isParam(node) && WmodeIsWindowCheck.hasInvalidObjectWmodeParam(node) && node.getParent() != null && FlashHelper.isFlashObject(node.getParent())) {
            line = node.getStartLinePosition();
        } else if (WmodeIsWindowCheck.isEmbed(node) && WmodeIsWindowCheck.hasInvalidEmbedWmodeAttribute(node) && FlashHelper.isFlashEmbed(node)) {
            line = WmodeIsWindowCheck.getWmodeAttributeLine(node);
        }
        if (line != 0) {
            this.createViolation(line, "Set the value of the 'wmode' parameter to 'window'.");
        }
    }

    private static int getWmodeAttributeLine(TagNode node) {
        return node.getProperty(WMODE).getLine();
    }

    private static boolean isParam(TagNode node) {
        return "PARAM".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasInvalidObjectWmodeParam(TagNode node) {
        String name = node.getPropertyValue("name");
        String value = node.getPropertyValue("value");
        return name != null && value != null && WMODE.equalsIgnoreCase(name) && !"WINDOW".equalsIgnoreCase(value);
    }

    private static boolean isEmbed(TagNode node) {
        return "EMBED".equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasInvalidEmbedWmodeAttribute(TagNode node) {
        String wmode = node.getPropertyValue(WMODE);
        return wmode != null && !"WINDOW".equalsIgnoreCase(wmode);
    }
}

