/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.core;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import java.io.IOException;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.html.core.HtmlLexer;
import org.sonar.plugins.html.core.HtmlTokenType;
import org.sonar.plugins.html.core.TokenLocation;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.visitor.DefaultNodeVisitor;

public class HtmlTokensVisitor
extends DefaultNodeVisitor {
    private static final Logger LOG = Loggers.get(HtmlTokensVisitor.class);
    private final SensorContext context;

    public HtmlTokensVisitor(SensorContext context) {
        this.context = context;
    }

    @Override
    public void startDocument(List<Node> nodes) {
        try {
            this.highlightAndDuplicate();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Giving up highlighting/handling duplication for file " + this.getHtmlSourceCode().inputFile(), (Throwable)e);
        }
    }

    private void highlightAndDuplicate() {
        String fileContent;
        if (!this.getHtmlSourceCode().shouldComputeMetric()) {
            return;
        }
        NewHighlighting highlighting = this.context.newHighlighting();
        InputFile inputFile = this.getHtmlSourceCode().inputFile();
        highlighting.onFile(inputFile);
        NewCpdTokens cpdTokens = this.context.newCpdTokens();
        cpdTokens.onFile(inputFile);
        try {
            fileContent = inputFile.contents();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read " + inputFile, e);
        }
        for (Token token : HtmlLexer.create(this.context.fileSystem().encoding()).lex(fileContent)) {
            TokenLocation tokenLocation;
            TokenType tokenType = token.getType();
            if (!tokenType.equals(GenericTokenType.EOF)) {
                tokenLocation = new TokenLocation(token);
                cpdTokens.addToken(tokenLocation.startLine(), tokenLocation.startCharacter(), tokenLocation.endLine(), tokenLocation.endCharacter(), token.getValue());
            }
            if (tokenType.equals(HtmlTokenType.DOCTYPE)) {
                HtmlTokensVisitor.highlight(highlighting, token, TypeOfText.STRUCTURED_COMMENT);
            } else if (tokenType.equals(HtmlTokenType.EXPRESSION)) {
                HtmlTokensVisitor.highlight(highlighting, token, TypeOfText.ANNOTATION);
            } else if (tokenType.equals(HtmlTokenType.TAG)) {
                HtmlTokensVisitor.highlight(highlighting, token, TypeOfText.KEYWORD);
            } else if (tokenType.equals(HtmlTokenType.ATTRIBUTE)) {
                tokenLocation = new TokenLocation(token);
                highlighting.highlight(tokenLocation.startLine(), tokenLocation.startCharacter() + 1, tokenLocation.endLine(), tokenLocation.endCharacter(), TypeOfText.STRING);
            }
            for (Trivia trivia : token.getTrivia()) {
                HtmlTokensVisitor.highlight(highlighting, trivia.getToken(), TypeOfText.COMMENT);
            }
        }
        highlighting.save();
        cpdTokens.save();
    }

    private static void highlight(NewHighlighting highlighting, Token token, TypeOfText typeOfText) {
        TokenLocation tokenLocation = new TokenLocation(token);
        highlighting.highlight(tokenLocation.startLine(), tokenLocation.startCharacter(), tokenLocation.endLine(), tokenLocation.endCharacter(), typeOfText);
    }
}

