/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import com.sonar.sslr.api.RecognitionException;
import com.sonar.sslr.api.Token;
import java.util.Arrays;
import java.util.List;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.internal.matchers.ImmutableInputBuffer;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.vm.CompiledGrammar;
import org.sonar.sslr.internal.vm.ErrorLocatingHandler;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.MachineHandler;
import org.sonar.sslr.internal.vm.MachineStack;
import org.sonar.sslr.internal.vm.MemoParsingExpression;
import org.sonar.sslr.internal.vm.lexerful.LexerfulParseErrorFormatter;
import org.sonar.sslr.parser.ParseError;
import org.sonar.sslr.parser.ParsingResult;

public class Machine
implements CharSequence {
    private final char[] input;
    private final Token[] tokens;
    private final int inputLength;
    private MachineStack stack;
    private int index;
    private int address;
    private boolean matched = true;
    private final ParseNode[] memos;
    private final int[] calls;
    private final MachineHandler handler;
    private boolean ignoreErrors = false;
    private static final MachineHandler NOP_HANDLER = new MachineHandler(){

        @Override
        public void onBacktrack(Machine machine) {
        }
    };

    public static ParseNode parse(List<Token> tokens, CompiledGrammar grammar) {
        Token[] inputTokens = tokens.toArray(new Token[tokens.size()]);
        ErrorLocatingHandler errorLocatingHandler = new ErrorLocatingHandler();
        Machine machine = new Machine(null, inputTokens, grammar.getInstructions(), errorLocatingHandler);
        machine.execute(grammar.getMatcher(grammar.getRootRuleKey()), grammar.getRootRuleOffset(), grammar.getInstructions());
        if (machine.matched) {
            return machine.stack.subNodes().get(0);
        }
        if (tokens.isEmpty()) {
            throw new RecognitionException(1, "No tokens");
        }
        int errorIndex = errorLocatingHandler.getErrorIndex();
        String errorMsg = new LexerfulParseErrorFormatter().format(tokens, errorIndex);
        int errorLine = errorIndex < tokens.size() ? tokens.get(errorIndex).getLine() : tokens.get(tokens.size() - 1).getLine();
        throw new RecognitionException(errorLine, errorMsg);
    }

    public static ParsingResult parse(char[] input, CompiledGrammar grammar) {
        Instruction[] instructions = grammar.getInstructions();
        ErrorLocatingHandler errorLocatingHandler = new ErrorLocatingHandler();
        Machine machine = new Machine(input, null, instructions, errorLocatingHandler);
        machine.execute(grammar.getMatcher(grammar.getRootRuleKey()), grammar.getRootRuleOffset(), instructions);
        if (machine.matched) {
            return new ParsingResult(new ImmutableInputBuffer(machine.input), machine.matched, machine.stack.subNodes().get(0), null);
        }
        ImmutableInputBuffer inputBuffer = new ImmutableInputBuffer(machine.input);
        ParseError parseError = new ParseError(inputBuffer, errorLocatingHandler.getErrorIndex());
        return new ParsingResult(inputBuffer, machine.matched, null, parseError);
    }

    private void execute(Matcher matcher, int offset, Instruction[] instructions) {
        this.push(-1);
        this.stack.setMatcher(matcher);
        this.jump(offset);
        this.execute(instructions);
    }

    public static boolean execute(String input, Instruction[] instructions) {
        Machine machine = new Machine(input, instructions);
        while (machine.address != -1 && machine.address < instructions.length) {
            instructions[machine.address].execute(machine);
        }
        return machine.matched;
    }

    public static boolean execute(Instruction[] instructions, Token ... input) {
        Machine machine = new Machine(null, input, instructions, NOP_HANDLER);
        while (machine.address != -1 && machine.address < instructions.length) {
            instructions[machine.address].execute(machine);
        }
        return machine.matched;
    }

    public Machine(String input, Instruction[] instructions, MachineHandler handler) {
        this(input.toCharArray(), null, instructions, handler);
    }

    private Machine(char[] input, Token[] tokens, Instruction[] instructions, MachineHandler handler) {
        this.input = input;
        this.tokens = tokens;
        this.inputLength = input != null ? input.length : tokens.length;
        this.handler = handler;
        this.memos = new ParseNode[this.inputLength + 1];
        this.stack = new MachineStack();
        this.stack = this.stack.getOrCreateChild();
        this.stack.setIndex(-1);
        this.calls = new int[instructions.length];
        Arrays.fill(this.calls, -1);
    }

    public Machine(String input, Instruction[] instructions) {
        this(input, instructions, NOP_HANDLER);
    }

    private void execute(Instruction[] instructions) {
        while (this.address != -1) {
            instructions[this.address].execute(this);
        }
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public void jump(int offset) {
        this.address += offset;
    }

    private void push(int address) {
        this.stack = this.stack.getOrCreateChild();
        this.stack.subNodes().clear();
        this.stack.setAddress(address);
        this.stack.setIndex(this.index);
        this.stack.setIgnoreErrors(this.ignoreErrors);
    }

    public void popReturn() {
        this.calls[this.stack.calledAddress()] = this.stack.leftRecursion();
        this.stack = this.stack.parent();
    }

    public void pushReturn(int returnOffset, Matcher matcher, int callOffset) {
        ParseNode memo = this.memos[this.index];
        if (memo != null && memo.getMatcher() == matcher) {
            this.stack.subNodes().add(memo);
            this.index = memo.getEndIndex();
            this.address += returnOffset;
        } else {
            this.push(this.address + returnOffset);
            this.stack.setMatcher(matcher);
            this.address += callOffset;
            if (this.calls[this.address] == this.index) {
                throw new GrammarException("Left recursion has been detected, involved rule: " + matcher.toString());
            }
            this.stack.setCalledAddress(this.address);
            this.stack.setLeftRecursion(this.calls[this.address]);
            this.calls[this.address] = this.index;
        }
    }

    public void pushBacktrack(int offset) {
        this.push(this.address + offset);
        this.stack.setMatcher(null);
    }

    public void pop() {
        this.stack = this.stack.parent();
    }

    public MachineStack peek() {
        return this.stack;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public void backtrack() {
        while (this.stack.isReturn()) {
            this.ignoreErrors = this.stack.isIgnoreErrors();
            if (!this.ignoreErrors) {
                this.handler.onBacktrack(this);
            }
            this.popReturn();
        }
        if (this.stack.isEmpty()) {
            this.address = -1;
            this.matched = false;
        } else {
            this.index = this.stack.index();
            this.address = this.stack.address();
            this.ignoreErrors = this.stack.isIgnoreErrors();
            this.stack = this.stack.parent();
        }
    }

    public void createNode() {
        ParseNode node = new ParseNode(this.stack.index(), this.index, this.stack.subNodes(), this.stack.matcher());
        this.stack.parent().subNodes().add(node);
        if (this.stack.matcher() instanceof MemoParsingExpression && ((MemoParsingExpression)this.stack.matcher()).shouldMemoize()) {
            this.memos[this.stack.index()] = node;
        }
    }

    public void createLeafNode(Matcher matcher, int offset) {
        ParseNode node = new ParseNode(this.index, this.index + offset, matcher);
        this.stack.subNodes().add(node);
        this.index += offset;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void advanceIndex(int offset) {
        this.index += offset;
    }

    @Override
    public int length() {
        return this.inputLength - this.index;
    }

    @Override
    public char charAt(int offset) {
        return this.input[this.index + offset];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public Token tokenAt(int offset) {
        return this.tokens[this.index + offset];
    }
}

