/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks.policy;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.ResourceAccessPolicyVector;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.Policy;

public class PolicyValidator {
    private PolicyValidator() {
    }

    public static List<InsecureStatement> findInsecureStatements(Policy policy) {
        ArrayList<InsecureStatement> result = new ArrayList<InsecureStatement>();
        for (Policy.Statement statement : policy.statement()) {
            Tree resourceAccessAction = statement.action().flatMap(PolicyValidator::findResourceAccessAction).orElse(null);
            if (resourceAccessAction == null) continue;
            statement.resource().flatMap(PolicyValidator::findInsecureResource).ifPresent(resource -> statement.effect().filter(PolicyValidator::isAllowEffect).ifPresent(effect -> result.add(new InsecureStatement((Tree)resource, (Tree)effect, resourceAccessAction))));
            statement.notResource().flatMap(PolicyValidator::findInsecureResource).ifPresent(notResource -> statement.effect().filter(PolicyValidator::isDenyEffect).ifPresent(effect -> result.add(new InsecureStatement((Tree)notResource, (Tree)effect, resourceAccessAction))));
        }
        return result;
    }

    static Optional<Tree> explore(Predicate<Tree> predicate, Tree tree) {
        if (tree instanceof Iterable) {
            return StreamSupport.stream(((Iterable)((Object)tree)).spliterator(), false).filter(Tree.class::isInstance).map(Tree.class::cast).filter(predicate).findAny();
        }
        if (predicate.test(tree)) {
            return Optional.of(tree);
        }
        return Optional.empty();
    }

    static Optional<Tree> findResourceAccessAction(Tree action) {
        return PolicyValidator.explore(ResourceAccessPolicyVector::isResourceAccessPolicy, action);
    }

    static Optional<Tree> findInsecureResource(Tree resource) {
        return PolicyValidator.explore(PolicyValidator::applyToAnyResource, resource);
    }

    private static boolean applyToAnyResource(Tree resource) {
        return TextUtils.isValue(resource, "*").isTrue();
    }

    private static boolean isAllowEffect(Tree effect) {
        return TextUtils.isValue(effect, "Allow").isTrue();
    }

    private static boolean isDenyEffect(Tree effect) {
        return TextUtils.isValue(effect, "Deny").isTrue();
    }

    public static class InsecureStatement {
        public final Tree resource;
        public final Tree effect;
        public final Tree action;

        public InsecureStatement(Tree resource, Tree effect, Tree action) {
            this.resource = resource;
            this.effect = effect;
            this.action = action;
        }
    }
}

