/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.extension;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.iac.common.extension.visitors.InputFileContext;

public class ParseException
extends RuntimeException {
    private final transient TextPointer position;
    private final transient String details;

    public static ParseException createGeneralParseException(String action, @Nullable InputFile inputFile, Exception cause, @Nullable TextPointer position) {
        String message = String.format("Cannot %s '%s'", action, ParseException.filenameAndPosition(inputFile, position));
        return new ParseException(message, position, cause.getMessage());
    }

    public static ParseException createParseException(String message, @Nullable InputFileContext inputFileContext, @Nullable TextPointer position) {
        if (inputFileContext != null) {
            return new ParseException(message + " at " + ParseException.filenameAndPosition(inputFileContext.inputFile, position), position, null);
        }
        return new ParseException(message + " at " + ParseException.filenameAndPosition(null, position), position, null);
    }

    private static String filenameAndPosition(@Nullable InputFile inputFile, @Nullable TextPointer position) {
        String filename;
        String string = filename = inputFile != null ? inputFile.toString() : "null";
        if (position != null) {
            return String.format("%s:%s:%s", filename, position.line(), position.lineOffset() + 1);
        }
        return filename;
    }

    public ParseException(String message, @Nullable TextPointer position, @Nullable String details) {
        super(message);
        this.position = position;
        this.details = details;
    }

    @CheckForNull
    public TextPointer getPosition() {
        return this.position;
    }

    @CheckForNull
    public String getDetails() {
        return this.details;
    }
}

