/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.Policy;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.terraform.api.tree.AttributeAccessTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.FileTree;
import org.sonar.iac.terraform.api.tree.LiteralExprTree;
import org.sonar.iac.terraform.api.tree.ObjectTree;
import org.sonar.iac.terraform.api.tree.TemplateExpressionTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.utils.PolicyUtils;

@Rule(key="S6249")
public class BucketsInsecureHttpCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure authorizing HTTP requests is safe here.";
    private static final String MESSAGE_SECONDARY_CONDITION = "HTTPS requests are denied.";
    private static final String MESSAGE_SECONDARY_EFFECT = "Non-conforming requests should be denied.";
    private static final String MESSAGE_SECONDARY_ACTION = "All S3 actions should be restricted.";
    private static final String MESSAGE_SECONDARY_PRINCIPAL = "All principals should be restricted.";
    private static final String MESSAGE_SECONDARY_RESOURCE = "All resources should be restricted.";

    public void initialize(InitContext init) {
        init.register(FileTree.class, (ctx, tree) -> {
            BucketsAndPoliciesCollector collector = new BucketsAndPoliciesCollector();
            collector.scan(new TreeContext(), (Tree)tree);
            BucketsInsecureHttpCheck.checkBucketsAndPolicies(ctx, BucketsInsecureHttpCheck.bucketsToPolicies(collector.buckets, collector.policies));
        });
    }

    private static void checkBucketsAndPolicies(CheckContext ctx, Map<BlockTree, Policy> bucketsToPolicies) {
        for (Map.Entry<BlockTree, Policy> entry : bucketsToPolicies.entrySet()) {
            if (entry.getValue() == null) {
                ctx.reportIssue((HasTextRange)entry.getKey().labels().get(0), MESSAGE);
                continue;
            }
            BucketsInsecureHttpCheck.checkBucketPolicy(ctx, entry.getKey(), entry.getValue());
        }
    }

    private static void checkBucketPolicy(CheckContext ctx, BlockTree bucket, Policy policy) {
        Map<ExpressionTree, String> insecureValues = PolicyValidator.getInsecureValues(policy);
        if (insecureValues.isEmpty()) {
            return;
        }
        List secondaryLocations = insecureValues.entrySet().stream().filter(e -> e.getKey() != null).map(e -> new SecondaryLocation((HasTextRange)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        ctx.reportIssue((HasTextRange)bucket.labels().get(0), MESSAGE, secondaryLocations);
    }

    private static Map<BlockTree, Policy> bucketsToPolicies(List<BlockTree> buckets, List<BlockTree> policies) {
        HashMap bucketIdToPolicies = new HashMap();
        for (BlockTree policy : policies) {
            PropertyUtils.value((Tree)policy, (String)"bucket").ifPresent(tree -> bucketIdToPolicies.put(tree, policy));
        }
        HashMap<BlockTree, Policy> result = new HashMap<BlockTree, Policy>();
        for (BlockTree bucket : buckets) {
            List<Policy> nestedPolicies = PolicyUtils.getPolicies(bucket);
            if (!nestedPolicies.isEmpty()) {
                result.put(bucket, nestedPolicies.get(0));
                continue;
            }
            Policy policy = bucketIdToPolicies.entrySet().stream().filter(e -> BucketsInsecureHttpCheck.correspondsToBucket((Tree)e.getKey(), bucket)).map(Map.Entry::getValue).map(tree -> PolicyUtils.getPolicies(tree).stream().findFirst()).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
            result.put(bucket, policy);
        }
        return result;
    }

    private static boolean correspondsToBucket(Tree key, BlockTree bucket) {
        if (key instanceof LiteralExprTree) {
            return PropertyUtils.value((Tree)bucket, (String)"bucket").map(name -> TextUtils.isValue((Tree)name, (String)((LiteralExprTree)key).value()).isTrue()).orElse(false);
        }
        if (key instanceof AttributeAccessTree && ((AttributeAccessTree)key).object() instanceof AttributeAccessTree && bucket.labels().size() >= 2) {
            AttributeAccessTree object = (AttributeAccessTree)((AttributeAccessTree)key).object();
            return object.attribute().value().equals(bucket.labels().get(1).value());
        }
        return false;
    }

    private static class PolicyValidator {
        private PolicyValidator() {
        }

        public static Map<ExpressionTree, String> getInsecureValues(Policy policy) {
            HashMap<ExpressionTree, String> result = new HashMap<ExpressionTree, String>();
            policy.statement().forEach(statement -> {
                statement.effect().filter(PolicyValidator::isInsecureEffect).ifPresent(effect -> result.put((ExpressionTree)effect, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_EFFECT));
                statement.condition().filter(PolicyValidator::isInsecureCondition).ifPresent(condition -> result.put((ExpressionTree)condition, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_CONDITION));
                statement.action().filter(PolicyValidator::isInsecureAction).ifPresent(action -> result.put((ExpressionTree)action, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_ACTION));
                statement.principal().filter(PolicyValidator::isInsecurePrincipal).ifPresent(principal -> result.put((ExpressionTree)principal, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_PRINCIPAL));
                statement.resource().filter(PolicyValidator::isInsecureResource).ifPresent(resource -> result.put((ExpressionTree)resource, BucketsInsecureHttpCheck.MESSAGE_SECONDARY_RESOURCE));
            });
            return result;
        }

        private static boolean isInsecureResource(Tree resource) {
            ArrayList<Tree> resourceIdentifiers = new ArrayList<Tree>();
            if (resource instanceof LiteralExprTree || resource instanceof TemplateExpressionTree) {
                resourceIdentifiers.add(resource);
            } else if (resource instanceof TupleTree) {
                resourceIdentifiers.addAll(((TupleTree)resource).elements().trees());
            }
            for (Tree resourceIdentifier : resourceIdentifiers) {
                if (!PolicyValidator.isResourceIdentifierSecure(resourceIdentifier)) continue;
                return false;
            }
            return !resourceIdentifiers.isEmpty();
        }

        private static boolean isResourceIdentifierSecure(Tree resourceIdentifier) {
            if (resourceIdentifier instanceof LiteralExprTree) {
                return ((LiteralExprTree)resourceIdentifier).value().endsWith("*");
            }
            if (resourceIdentifier instanceof TemplateExpressionTree) {
                List<ExpressionTree> parts = ((TemplateExpressionTree)resourceIdentifier).parts();
                return !parts.isEmpty() && PolicyValidator.isResourceIdentifierSecure(parts.get(parts.size() - 1));
            }
            return true;
        }

        private static boolean isInsecurePrincipal(Tree principal) {
            return PropertyUtils.value((Tree)principal, (String)"AWS", ExpressionTree.class).filter(awsPrincipal -> awsPrincipal.is(TerraformTree.Kind.TUPLE) || TextUtils.isValue((Tree)awsPrincipal, (String)"*").isFalse()).isPresent();
        }

        private static boolean isInsecureAction(Tree action) {
            return TextUtils.isValue((Tree)action, (String)"*").isFalse() && TextUtils.isValue((Tree)action, (String)"s3:*").isFalse();
        }

        private static boolean isInsecureEffect(Tree effect) {
            return TextUtils.isValue((Tree)effect, (String)"Deny").isFalse();
        }

        private static boolean isInsecureCondition(Tree condition) {
            Optional bool = PropertyUtils.value((Tree)condition, (String)"Bool");
            if (!bool.isPresent() || !(bool.get() instanceof ObjectTree)) {
                return false;
            }
            return PropertyUtils.value((Tree)((Tree)bool.get()), (String)"aws:SecureTransport").filter(e -> !TextUtils.isValueFalse((Tree)e)).isPresent();
        }
    }

    private static class BucketsAndPoliciesCollector
    extends TreeVisitor<TreeContext> {
        private final List<BlockTree> buckets = new ArrayList<BlockTree>();
        private final List<BlockTree> policies = new ArrayList<BlockTree>();

        public BucketsAndPoliciesCollector() {
            this.register(BlockTree.class, (ctx, tree) -> {
                if (AbstractResourceCheck.isS3BucketResource(tree)) {
                    this.buckets.add((BlockTree)tree);
                } else if (AbstractResourceCheck.isResource(tree, "aws_s3_bucket_policy")) {
                    this.policies.add((BlockTree)tree);
                }
            });
        }
    }
}

