/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.terraform.api.tree.AttributeAccessTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.FileTree;
import org.sonar.iac.terraform.api.tree.LabelTree;
import org.sonar.iac.terraform.api.tree.LiteralExprTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6281")
public class BucketsPublicAclOrPolicyCheck
implements IacCheck {
    private static final String MESSAGE = "Make sure allowing public ACL/policies to be set is safe here.";
    private static final String OMITTING_MESSAGE = "No Public Access Block configuration prevents public ACL/policies to be set on this S3 bucket. Make sure it is safe here.";
    private static final String SECONDARY_MSG_PROPERTY = "Set this property to true";
    private static final String SECONDARY_MSG_BUCKET = "Related bucket";
    private static final String PAB = "aws_s3_bucket_public_access_block";
    private static final Set<String> PAB_STATEMENTS = new HashSet<String>(Arrays.asList("block_public_policy", "block_public_acls", "ignore_public_acls", "restrict_public_buckets"));

    public void initialize(InitContext init) {
        init.register(FileTree.class, (ctx, tree) -> {
            BucketAndResourceCollector collector = BucketAndResourceCollector.collect(tree);
            collector.getAssignedBuckets().forEach(bucket -> BucketsPublicAclOrPolicyCheck.checkS3Bucket(ctx, bucket, collector.getPublicAccessBlocks()));
            collector.getPublicAccessBlocks().forEach(resource -> BucketsPublicAclOrPolicyCheck.checkPublicAccessBlocks(ctx, resource, null));
        });
    }

    private static void checkS3Bucket(CheckContext ctx, S3Bucket bucket, Set<BlockTree> publicAccessBlocks) {
        Optional<BlockTree> publicAccessBlock = bucket.resource(PAB);
        if (publicAccessBlock.isPresent()) {
            BlockTree pab = publicAccessBlock.get();
            publicAccessBlocks.remove(pab);
            BucketsPublicAclOrPolicyCheck.checkPublicAccessBlocks(ctx, pab, bucket);
        } else {
            ctx.reportIssue((HasTextRange)bucket.label(), OMITTING_MESSAGE);
        }
    }

    private static void checkPublicAccessBlocks(CheckContext ctx, BlockTree pab, @Nullable S3Bucket s3Bucket) {
        List<SecondaryLocation> secLoc = BucketsPublicAclOrPolicyCheck.checkWrongConfiguration(pab);
        if (!secLoc.isEmpty() || BucketsPublicAclOrPolicyCheck.hasMissingStatement(pab)) {
            if (s3Bucket != null) {
                secLoc.add(new SecondaryLocation((HasTextRange)s3Bucket.label(), SECONDARY_MSG_BUCKET));
            }
            ctx.reportIssue((HasTextRange)pab.labels().get(0), MESSAGE, secLoc);
        }
    }

    private static List<SecondaryLocation> checkWrongConfiguration(BlockTree publicAccessBlock) {
        return PAB_STATEMENTS.stream().map(e -> PropertyUtils.value((Tree)publicAccessBlock, (String)e)).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).filter(TextUtils::isValueFalse).map(value -> new SecondaryLocation((HasTextRange)value, SECONDARY_MSG_PROPERTY)).collect(Collectors.toList());
    }

    private static boolean hasMissingStatement(BlockTree publicAccessBlock) {
        return PAB_STATEMENTS.stream().anyMatch(e -> PropertyUtils.isMissing((Tree)publicAccessBlock, (String)e));
    }

    private static class BucketAndResourceCollector
    extends TreeVisitor<TreeContext> {
        private final List<S3Bucket> buckets = new ArrayList<S3Bucket>();
        private final Set<BlockTree> publicAccessBlocks = new LinkedHashSet<BlockTree>();
        private final List<BlockTree> resources = new ArrayList<BlockTree>();

        public BucketAndResourceCollector() {
            this.register(BlockTree.class, (ctx, tree) -> {
                if (AbstractResourceCheck.isS3BucketResource(tree)) {
                    S3Bucket bucket = new S3Bucket((BlockTree)tree);
                    this.buckets.add(bucket);
                } else if (AbstractResourceCheck.isResource(tree)) {
                    if (AbstractResourceCheck.isResource(tree, BucketsPublicAclOrPolicyCheck.PAB)) {
                        this.publicAccessBlocks.add((BlockTree)tree);
                    }
                    this.resources.add((BlockTree)tree);
                }
            });
        }

        public static BucketAndResourceCollector collect(FileTree tree) {
            BucketAndResourceCollector collector = new BucketAndResourceCollector();
            collector.scan(new TreeContext(), tree);
            return collector;
        }

        protected void after(TreeContext ctx, Tree root) {
            this.resources.stream().filter(resource -> !resource.labels().isEmpty()).forEach(resource -> PropertyUtils.value((Tree)resource, (String)"bucket", TerraformTree.class).ifPresent(identifier -> {
                if (identifier.is(TerraformTree.Kind.STRING_LITERAL)) {
                    this.assignByBucketName((LiteralExprTree)identifier, (BlockTree)resource);
                } else if (identifier.is(TerraformTree.Kind.ATTRIBUTE_ACCESS)) {
                    this.assignByResourceName((AttributeAccessTree)identifier, (BlockTree)resource);
                }
            }));
        }

        private void assignByResourceName(AttributeAccessTree identifier, BlockTree resource) {
            if (identifier.object().is(TerraformTree.Kind.ATTRIBUTE_ACCESS)) {
                String name = ((AttributeAccessTree)identifier.object()).attribute().value();
                this.buckets.stream().filter(bucket -> name.equals(bucket.resourceName)).forEach(bucket -> bucket.assignResource(resource));
            }
        }

        private void assignByBucketName(LiteralExprTree bucketName, BlockTree resource) {
            this.buckets.stream().filter(bucket -> bucketName.value().equals(bucket.bucketName)).forEach(bucket -> bucket.assignResource(resource));
        }

        private List<S3Bucket> getAssignedBuckets() {
            return this.buckets;
        }

        private Set<BlockTree> getPublicAccessBlocks() {
            return this.publicAccessBlocks;
        }
    }

    private static class S3Bucket {
        private final Map<String, BlockTree> resources = new HashMap<String, BlockTree>();
        private final LabelTree label;
        private final String resourceName;
        private final String bucketName;

        private S3Bucket(BlockTree bucket) {
            this.label = bucket.labels().get(0);
            this.resourceName = bucket.labels().size() >= 2 ? bucket.labels().get(1).value() : null;
            this.bucketName = PropertyUtils.value((Tree)bucket, (String)"bucket").filter(LiteralExprTree.class::isInstance).map(e -> ((LiteralExprTree)e).value()).orElse(null);
        }

        private void assignResource(BlockTree resource) {
            this.resources.put(resource.labels().get(0).value(), resource);
        }

        public Optional<BlockTree> resource(String resourceName) {
            return Optional.ofNullable(this.resources.getOrDefault(resourceName, null));
        }

        public LabelTree label() {
            return this.label;
        }
    }
}

