/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6303")
public class DisabledDBEncryptionCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE_DB_INSTANCE = "Make sure that using unencrypted RDS DB Instances is safe here.";
    private static final String MESSAGE_RDS_CLUSTER = "Make sure that using an unencrypted RDS DB Cluster is safe here.";
    private static final String MESSAGE_DB_INSTANCE_BACKUP_REPLICATION = "Make sure that using an unencrypted DB backup replication is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"storage_encrypted\" disables databases encryption. Make sure it is safe here.";
    private static final String SECONDARY_MESSAGE_DB_INSTANCE = "Related RDS DB Instance";
    private static final String SECONDARY_MESSAGE_RDS_CLUSTER = "Related RDS Cluster";
    private static final List<String> EXCLUDE_AURORA_ATTRIBUTE = List.of("aurora", "aurora-mysql", "aurora-postgresql");

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_db_instance", DisabledDBEncryptionCheck::checkAwsDbInstance);
        this.register("aws_rds_cluster", DisabledDBEncryptionCheck::checkAwsRdsCluster);
        this.register("aws_db_instance_automated_backups_replication", DisabledDBEncryptionCheck::checkAwsDbInstanceBackupReplication);
    }

    private static void checkAwsDbInstance(ResourceSymbol resource) {
        AttributeSymbol engine = resource.attribute("engine");
        if (EXCLUDE_AURORA_ATTRIBUTE.stream().anyMatch(auroraAttribute -> engine.is(ExpressionPredicate.equalTo(auroraAttribute)))) {
            return;
        }
        ((AttributeSymbol)resource.attribute("storage_encrypted").reportIf(ExpressionPredicate.isFalse(), MESSAGE_DB_INSTANCE, new SecondaryLocation[]{resource.toSecondary(SECONDARY_MESSAGE_DB_INSTANCE)})).reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]);
    }

    private static void checkAwsRdsCluster(ResourceSymbol resource) {
        AttributeSymbol engineMode = resource.attribute("engine_mode");
        AttributeSymbol storageEncrypted = resource.attribute("storage_encrypted");
        storageEncrypted.reportIf(ExpressionPredicate.isFalse(), MESSAGE_RDS_CLUSTER, new SecondaryLocation[]{resource.toSecondary(SECONDARY_MESSAGE_RDS_CLUSTER)});
        if (engineMode.isAbsent() || engineMode.is(ExpressionPredicate.notEqualTo("serverless"))) {
            storageEncrypted.reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]);
        }
    }

    private static void checkAwsDbInstanceBackupReplication(ResourceSymbol resource) {
        resource.attribute("kms_key_id").reportIfAbsent(MESSAGE_DB_INSTANCE_BACKUP_REPLICATION, new SecondaryLocation[0]);
    }
}

