/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6332")
public class DisabledEFSEncryptionCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted EFS file systems is safe here.";
    private static final String SECONDARY_MESSAGE = "Related file system";
    private static final String OMITTING_MESSAGE = "Omitting \"encrypted\" disables EFS file systems encryption. Make sure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_efs_file_system", (ResourceSymbol resource) -> ((AttributeSymbol)resource.attribute("encrypted").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0])).reportIf(ExpressionPredicate.isFalse(), MESSAGE, new SecondaryLocation[]{resource.toSecondary(SECONDARY_MESSAGE)}));
    }
}

