/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6308")
public class DisabledESDomainEncryptionCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted Elasticsearch domains is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"encrypt_at_rest.enabled\" disables Elasticsearch domains encryption. Make sure it is safe here.";
    private static final String SECONDARY_MESSAGE = "Related domain";

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_elasticsearch_domain", (ResourceSymbol resource) -> ((AttributeSymbol)((BlockSymbol)resource.block("encrypt_at_rest").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0])).attribute("enabled").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[]{resource.toSecondary(SECONDARY_MESSAGE)})).reportIf(ExpressionPredicate.isFalse(), MESSAGE, new SecondaryLocation[]{resource.toSecondary(SECONDARY_MESSAGE)}));
    }
}

