/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PrivilegeEscalationVector;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.common.checks.policy.Policy;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.PolicyUtils;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6317")
public class PrivilegeEscalationCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "This policy is vulnerable to the \"%s\" privilege escalation vector. Remove permissions or restrict the set of resources they apply to.";
    private static final String MESSAGE_ACTION_MULTIPLE = "When combined with others, this permission enables the \"%s\" escalation vector.";
    private static final String MESSAGE_ACTION_SINGLE = "This permission enables the \"%s\" escalation vector.";
    private static final String MESSAGE_STATEMENT_ALL = "Permissions are granted on all resources.";

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_iam_policy", (ResourceSymbol resource) -> PolicyUtils.getPolicies(resource.tree).forEach(policy -> PrivilegeEscalationCheck.checkPrivilegeEscalation(resource, policy)));
    }

    private static void checkPrivilegeEscalation(ResourceSymbol resourceSymbol, Policy policy) {
        for (Policy.Statement statement : policy.statement()) {
            Optional action = statement.action();
            if (!action.isPresent() || !(action.get() instanceof TupleTree)) continue;
            List actionTrees = ((TupleTree)action.get()).elements().trees().stream().map(Tree.class::cast).collect(Collectors.toList());
            Optional vectorOpt = PrivilegeEscalationVector.getStatementEscalationVector((Policy.Statement)statement, actionTrees);
            if (!vectorOpt.isPresent()) continue;
            PrivilegeEscalationVector vector = (PrivilegeEscalationVector)vectorOpt.get();
            List<SecondaryLocation> secondaryLocations = PrivilegeEscalationCheck.secondaryLocations(statement, vector);
            resourceSymbol.report(String.format(MESSAGE, vector.getName()), secondaryLocations);
        }
    }

    private static List<SecondaryLocation> secondaryLocations(Policy.Statement statement, PrivilegeEscalationVector vector) {
        ArrayList<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
        secondaryLocations.addAll(PrivilegeEscalationCheck.retrieveSecondaryLocationsFromAction(statement, vector));
        secondaryLocations.addAll(PrivilegeEscalationCheck.retrieveSecondaryLocationsFromResource(statement));
        return secondaryLocations;
    }

    private static List<SecondaryLocation> retrieveSecondaryLocationsFromResource(Policy.Statement statement) {
        ArrayList<SecondaryLocation> secondaryLocationsFromResource = new ArrayList<SecondaryLocation>();
        statement.resource().ifPresent(resource -> {
            if (TextUtils.isValue((Tree)resource, (String)"*").isTrue()) {
                secondaryLocationsFromResource.add(new SecondaryLocation((HasTextRange)resource, MESSAGE_STATEMENT_ALL));
            }
        });
        return secondaryLocationsFromResource;
    }

    private static List<SecondaryLocation> retrieveSecondaryLocationsFromAction(Policy.Statement statement, PrivilegeEscalationVector vector) {
        ArrayList<SecondaryLocation> secondaryLocationsFromAction = new ArrayList<SecondaryLocation>();
        String actionsMsg = vector.getPermissions().size() == 1 ? String.format(MESSAGE_ACTION_SINGLE, vector.getName()) : String.format(MESSAGE_ACTION_MULTIPLE, vector.getName());
        statement.action().ifPresent(tree -> ((TupleTree)tree).elements().trees().stream().filter(actionElement -> TextUtils.getValue((Tree)actionElement).map(value -> PrivilegeEscalationVector.actionEnablesVector((PrivilegeEscalationVector)vector, (String)value)).orElse(false)).forEach(actionElement -> secondaryLocationsFromAction.add(new SecondaryLocation((HasTextRange)actionElement, actionsMsg))));
        return secondaryLocationsFromAction;
    }
}

